/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest;

public class DescribeInstanceAttributeRequestMarshaller
implements Marshaller<Request<DescribeInstanceAttributeRequest>, DescribeInstanceAttributeRequest> {
    public Request<DescribeInstanceAttributeRequest> marshall(DescribeInstanceAttributeRequest describeInstanceAttributeRequest) {
        if (describeInstanceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstanceAttributeRequest, "EC2Client");
        request.addParameter("Action", "DescribeInstanceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstanceAttributeRequest.attributeString() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)describeInstanceAttributeRequest.attributeString()));
        }
        if (describeInstanceAttributeRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)describeInstanceAttributeRequest.instanceId()));
        }
        return request;
    }
}

