/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.AllocateHostsRequest;

public class AllocateHostsRequestMarshaller
implements Marshaller<Request<AllocateHostsRequest>, AllocateHostsRequest> {
    public Request<AllocateHostsRequest> marshall(AllocateHostsRequest allocateHostsRequest) {
        if (allocateHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)allocateHostsRequest, "EC2Client");
        request.addParameter("Action", "AllocateHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (allocateHostsRequest.autoPlacementString() != null) {
            request.addParameter("AutoPlacement", StringUtils.fromString((String)allocateHostsRequest.autoPlacementString()));
        }
        if (allocateHostsRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)allocateHostsRequest.availabilityZone()));
        }
        if (allocateHostsRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)allocateHostsRequest.clientToken()));
        }
        if (allocateHostsRequest.instanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)allocateHostsRequest.instanceType()));
        }
        if (allocateHostsRequest.quantity() != null) {
            request.addParameter("Quantity", StringUtils.fromInteger((Integer)allocateHostsRequest.quantity()));
        }
        return request;
    }
}

