/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcClassicLink
implements ToCopyableBuilder<Builder, VpcClassicLink> {
    private final Boolean classicLinkEnabled;
    private final List<Tag> tags;
    private final String vpcId;

    private VpcClassicLink(BuilderImpl builder) {
        this.classicLinkEnabled = builder.classicLinkEnabled;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    public Boolean classicLinkEnabled() {
        return this.classicLinkEnabled;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.classicLinkEnabled() == null ? 0 : this.classicLinkEnabled().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcClassicLink)) {
            return false;
        }
        VpcClassicLink other = (VpcClassicLink)obj;
        if (other.classicLinkEnabled() == null ^ this.classicLinkEnabled() == null) {
            return false;
        }
        if (other.classicLinkEnabled() != null && !other.classicLinkEnabled().equals(this.classicLinkEnabled())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.classicLinkEnabled() != null) {
            sb.append("ClassicLinkEnabled: ").append(this.classicLinkEnabled()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClassicLinkEnabled": {
                return Optional.of(clazz.cast(this.classicLinkEnabled()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean classicLinkEnabled;
        private List<Tag> tags;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcClassicLink model) {
            this.classicLinkEnabled(model.classicLinkEnabled);
            this.tags(model.tags);
            this.vpcId(model.vpcId);
        }

        public final Boolean getClassicLinkEnabled() {
            return this.classicLinkEnabled;
        }

        @Override
        public final Builder classicLinkEnabled(Boolean classicLinkEnabled) {
            this.classicLinkEnabled = classicLinkEnabled;
            return this;
        }

        public final void setClassicLinkEnabled(Boolean classicLinkEnabled) {
            this.classicLinkEnabled = classicLinkEnabled;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public VpcClassicLink build() {
            return new VpcClassicLink(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcClassicLink> {
        public Builder classicLinkEnabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder vpcId(String var1);
    }
}

