/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SecurityGroupReference
implements ToCopyableBuilder<Builder, SecurityGroupReference> {
    private final String groupId;
    private final String referencingVpcId;
    private final String vpcPeeringConnectionId;

    private SecurityGroupReference(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.referencingVpcId = builder.referencingVpcId;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public String groupId() {
        return this.groupId;
    }

    public String referencingVpcId() {
        return this.referencingVpcId;
    }

    public String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.groupId() == null ? 0 : this.groupId().hashCode());
        hashCode = 31 * hashCode + (this.referencingVpcId() == null ? 0 : this.referencingVpcId().hashCode());
        hashCode = 31 * hashCode + (this.vpcPeeringConnectionId() == null ? 0 : this.vpcPeeringConnectionId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupReference)) {
            return false;
        }
        SecurityGroupReference other = (SecurityGroupReference)obj;
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.referencingVpcId() == null ^ this.referencingVpcId() == null) {
            return false;
        }
        if (other.referencingVpcId() != null && !other.referencingVpcId().equals(this.referencingVpcId())) {
            return false;
        }
        if (other.vpcPeeringConnectionId() == null ^ this.vpcPeeringConnectionId() == null) {
            return false;
        }
        return other.vpcPeeringConnectionId() == null || other.vpcPeeringConnectionId().equals(this.vpcPeeringConnectionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groupId() != null) {
            sb.append("GroupId: ").append(this.groupId()).append(",");
        }
        if (this.referencingVpcId() != null) {
            sb.append("ReferencingVpcId: ").append(this.referencingVpcId()).append(",");
        }
        if (this.vpcPeeringConnectionId() != null) {
            sb.append("VpcPeeringConnectionId: ").append(this.vpcPeeringConnectionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "ReferencingVpcId": {
                return Optional.of(clazz.cast(this.referencingVpcId()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.of(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String groupId;
        private String referencingVpcId;
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupReference model) {
            this.groupId(model.groupId);
            this.referencingVpcId(model.referencingVpcId);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getReferencingVpcId() {
            return this.referencingVpcId;
        }

        @Override
        public final Builder referencingVpcId(String referencingVpcId) {
            this.referencingVpcId = referencingVpcId;
            return this;
        }

        public final void setReferencingVpcId(String referencingVpcId) {
            this.referencingVpcId = referencingVpcId;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        public SecurityGroupReference build() {
            return new SecurityGroupReference(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SecurityGroupReference> {
        public Builder groupId(String var1);

        public Builder referencingVpcId(String var1);

        public Builder vpcPeeringConnectionId(String var1);
    }
}

