/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RunScheduledInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RunScheduledInstancesRequest> {
    private final String clientToken;
    private final Integer instanceCount;
    private final ScheduledInstancesLaunchSpecification launchSpecification;
    private final String scheduledInstanceId;

    private RunScheduledInstancesRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.launchSpecification = builder.launchSpecification;
        this.scheduledInstanceId = builder.scheduledInstanceId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public ScheduledInstancesLaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public String scheduledInstanceId() {
        return this.scheduledInstanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.launchSpecification() == null ? 0 : this.launchSpecification().hashCode());
        hashCode = 31 * hashCode + (this.scheduledInstanceId() == null ? 0 : this.scheduledInstanceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunScheduledInstancesRequest)) {
            return false;
        }
        RunScheduledInstancesRequest other = (RunScheduledInstancesRequest)((Object)obj);
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.launchSpecification() == null ^ this.launchSpecification() == null) {
            return false;
        }
        if (other.launchSpecification() != null && !other.launchSpecification().equals(this.launchSpecification())) {
            return false;
        }
        if (other.scheduledInstanceId() == null ^ this.scheduledInstanceId() == null) {
            return false;
        }
        return other.scheduledInstanceId() == null || other.scheduledInstanceId().equals(this.scheduledInstanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.launchSpecification() != null) {
            sb.append("LaunchSpecification: ").append(this.launchSpecification()).append(",");
        }
        if (this.scheduledInstanceId() != null) {
            sb.append("ScheduledInstanceId: ").append(this.scheduledInstanceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "LaunchSpecification": {
                return Optional.of(clazz.cast(this.launchSpecification()));
            }
            case "ScheduledInstanceId": {
                return Optional.of(clazz.cast(this.scheduledInstanceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private Integer instanceCount;
        private ScheduledInstancesLaunchSpecification launchSpecification;
        private String scheduledInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(RunScheduledInstancesRequest model) {
            this.clientToken(model.clientToken);
            this.instanceCount(model.instanceCount);
            this.launchSpecification(model.launchSpecification);
            this.scheduledInstanceId(model.scheduledInstanceId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final ScheduledInstancesLaunchSpecification.Builder getLaunchSpecification() {
            return this.launchSpecification != null ? this.launchSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecification(ScheduledInstancesLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(ScheduledInstancesLaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        public final String getScheduledInstanceId() {
            return this.scheduledInstanceId;
        }

        @Override
        public final Builder scheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
            return this;
        }

        public final void setScheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
        }

        public RunScheduledInstancesRequest build() {
            return new RunScheduledInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RunScheduledInstancesRequest> {
        public Builder clientToken(String var1);

        public Builder instanceCount(Integer var1);

        public Builder launchSpecification(ScheduledInstancesLaunchSpecification var1);

        public Builder scheduledInstanceId(String var1);
    }
}

