/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.PermissionGroup;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LaunchPermission
implements ToCopyableBuilder<Builder, LaunchPermission> {
    private final String group;
    private final String userId;

    private LaunchPermission(BuilderImpl builder) {
        this.group = builder.group;
        this.userId = builder.userId;
    }

    public PermissionGroup group() {
        return PermissionGroup.fromValue(this.group);
    }

    public String groupString() {
        return this.group;
    }

    public String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.groupString() == null ? 0 : this.groupString().hashCode());
        hashCode = 31 * hashCode + (this.userId() == null ? 0 : this.userId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPermission)) {
            return false;
        }
        LaunchPermission other = (LaunchPermission)obj;
        if (other.groupString() == null ^ this.groupString() == null) {
            return false;
        }
        if (other.groupString() != null && !other.groupString().equals(this.groupString())) {
            return false;
        }
        if (other.userId() == null ^ this.userId() == null) {
            return false;
        }
        return other.userId() == null || other.userId().equals(this.userId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groupString() != null) {
            sb.append("Group: ").append(this.groupString()).append(",");
        }
        if (this.userId() != null) {
            sb.append("UserId: ").append(this.userId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.of(clazz.cast(this.groupString()));
            }
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String group;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPermission model) {
            this.group(model.group);
            this.userId(model.userId);
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public final Builder group(PermissionGroup group) {
            this.group(group.toString());
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public LaunchPermission build() {
            return new LaunchPermission(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LaunchPermission> {
        public Builder group(String var1);

        public Builder group(PermissionGroup var1);

        public Builder userId(String var1);
    }
}

