/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment;
import software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddress;
import software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddressListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceNetworkInterface
implements ToCopyableBuilder<Builder, InstanceNetworkInterface> {
    private final InstanceNetworkInterfaceAssociation association;
    private final InstanceNetworkInterfaceAttachment attachment;
    private final String description;
    private final List<GroupIdentifier> groups;
    private final List<InstanceIpv6Address> ipv6Addresses;
    private final String macAddress;
    private final String networkInterfaceId;
    private final String ownerId;
    private final String privateDnsName;
    private final String privateIpAddress;
    private final List<InstancePrivateIpAddress> privateIpAddresses;
    private final Boolean sourceDestCheck;
    private final String status;
    private final String subnetId;
    private final String vpcId;

    private InstanceNetworkInterface(BuilderImpl builder) {
        this.association = builder.association;
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.groups = builder.groups;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.macAddress = builder.macAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ownerId = builder.ownerId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
    }

    public InstanceNetworkInterfaceAssociation association() {
        return this.association;
    }

    public InstanceNetworkInterfaceAttachment attachment() {
        return this.attachment;
    }

    public String description() {
        return this.description;
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public List<InstanceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public List<InstancePrivateIpAddress> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public NetworkInterfaceStatus status() {
        return NetworkInterfaceStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.association() == null ? 0 : this.association().hashCode());
        hashCode = 31 * hashCode + (this.attachment() == null ? 0 : this.attachment().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.groups() == null ? 0 : this.groups().hashCode());
        hashCode = 31 * hashCode + (this.ipv6Addresses() == null ? 0 : this.ipv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.macAddress() == null ? 0 : this.macAddress().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.ownerId() == null ? 0 : this.ownerId().hashCode());
        hashCode = 31 * hashCode + (this.privateDnsName() == null ? 0 : this.privateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddresses() == null ? 0 : this.privateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.sourceDestCheck() == null ? 0 : this.sourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterface)) {
            return false;
        }
        InstanceNetworkInterface other = (InstanceNetworkInterface)obj;
        if (other.association() == null ^ this.association() == null) {
            return false;
        }
        if (other.association() != null && !other.association().equals(this.association())) {
            return false;
        }
        if (other.attachment() == null ^ this.attachment() == null) {
            return false;
        }
        if (other.attachment() != null && !other.attachment().equals(this.attachment())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.ipv6Addresses() == null ^ this.ipv6Addresses() == null) {
            return false;
        }
        if (other.ipv6Addresses() != null && !other.ipv6Addresses().equals(this.ipv6Addresses())) {
            return false;
        }
        if (other.macAddress() == null ^ this.macAddress() == null) {
            return false;
        }
        if (other.macAddress() != null && !other.macAddress().equals(this.macAddress())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.privateDnsName() == null ^ this.privateDnsName() == null) {
            return false;
        }
        if (other.privateDnsName() != null && !other.privateDnsName().equals(this.privateDnsName())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.privateIpAddresses() == null ^ this.privateIpAddresses() == null) {
            return false;
        }
        if (other.privateIpAddresses() != null && !other.privateIpAddresses().equals(this.privateIpAddresses())) {
            return false;
        }
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        if (other.sourceDestCheck() != null && !other.sourceDestCheck().equals(this.sourceDestCheck())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.association() != null) {
            sb.append("Association: ").append(this.association()).append(",");
        }
        if (this.attachment() != null) {
            sb.append("Attachment: ").append(this.attachment()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.groups() != null) {
            sb.append("Groups: ").append(this.groups()).append(",");
        }
        if (this.ipv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(this.ipv6Addresses()).append(",");
        }
        if (this.macAddress() != null) {
            sb.append("MacAddress: ").append(this.macAddress()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.ownerId() != null) {
            sb.append("OwnerId: ").append(this.ownerId()).append(",");
        }
        if (this.privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.privateDnsName()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        if (this.privateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(this.privateIpAddresses()).append(",");
        }
        if (this.sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(this.sourceDestCheck()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Association": {
                return Optional.of(clazz.cast(this.association()));
            }
            case "Attachment": {
                return Optional.of(clazz.cast(this.attachment()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Groups": {
                return Optional.of(clazz.cast(this.groups()));
            }
            case "Ipv6Addresses": {
                return Optional.of(clazz.cast(this.ipv6Addresses()));
            }
            case "MacAddress": {
                return Optional.of(clazz.cast(this.macAddress()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "OwnerId": {
                return Optional.of(clazz.cast(this.ownerId()));
            }
            case "PrivateDnsName": {
                return Optional.of(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.of(clazz.cast(this.privateIpAddress()));
            }
            case "PrivateIpAddresses": {
                return Optional.of(clazz.cast(this.privateIpAddresses()));
            }
            case "SourceDestCheck": {
                return Optional.of(clazz.cast(this.sourceDestCheck()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private InstanceNetworkInterfaceAssociation association;
        private InstanceNetworkInterfaceAttachment attachment;
        private String description;
        private List<GroupIdentifier> groups;
        private List<InstanceIpv6Address> ipv6Addresses;
        private String macAddress;
        private String networkInterfaceId;
        private String ownerId;
        private String privateDnsName;
        private String privateIpAddress;
        private List<InstancePrivateIpAddress> privateIpAddresses;
        private Boolean sourceDestCheck;
        private String status;
        private String subnetId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterface model) {
            this.association(model.association);
            this.attachment(model.attachment);
            this.description(model.description);
            this.groups(model.groups);
            this.ipv6Addresses(model.ipv6Addresses);
            this.macAddress(model.macAddress);
            this.networkInterfaceId(model.networkInterfaceId);
            this.ownerId(model.ownerId);
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
            this.privateIpAddresses(model.privateIpAddresses);
            this.sourceDestCheck(model.sourceDestCheck);
            this.status(model.status);
            this.subnetId(model.subnetId);
            this.vpcId(model.vpcId);
        }

        public final InstanceNetworkInterfaceAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        @Override
        public final Builder association(InstanceNetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(InstanceNetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        public final InstanceNetworkInterfaceAttachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(InstanceNetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(InstanceNetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final Collection<InstanceIpv6Address.Builder> getIpv6Addresses() {
            return this.ipv6Addresses != null ? (Collection)this.ipv6Addresses.stream().map(InstanceIpv6Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<InstancePrivateIpAddress.Builder> getPrivateIpAddresses() {
            return this.privateIpAddresses != null ? (Collection)this.privateIpAddresses.stream().map(InstancePrivateIpAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder privateIpAddresses(Collection<InstancePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = InstancePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(InstancePrivateIpAddress ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<InstancePrivateIpAddress.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = InstancePrivateIpAddressListCopier.copyFromBuilder(privateIpAddresses);
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkInterfaceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public InstanceNetworkInterface build() {
            return new InstanceNetworkInterface(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceNetworkInterface> {
        public Builder association(InstanceNetworkInterfaceAssociation var1);

        public Builder attachment(InstanceNetworkInterfaceAttachment var1);

        public Builder description(String var1);

        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder ipv6Addresses(Collection<InstanceIpv6Address> var1);

        public Builder ipv6Addresses(InstanceIpv6Address ... var1);

        public Builder macAddress(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder ownerId(String var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddresses(Collection<InstancePrivateIpAddress> var1);

        public Builder privateIpAddresses(InstancePrivateIpAddress ... var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder status(String var1);

        public Builder status(NetworkInterfaceStatus var1);

        public Builder subnetId(String var1);

        public Builder vpcId(String var1);
    }
}

