/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HostProperties
implements ToCopyableBuilder<Builder, HostProperties> {
    private final Integer cores;
    private final String instanceType;
    private final Integer sockets;
    private final Integer totalVCpus;

    private HostProperties(BuilderImpl builder) {
        this.cores = builder.cores;
        this.instanceType = builder.instanceType;
        this.sockets = builder.sockets;
        this.totalVCpus = builder.totalVCpus;
    }

    public Integer cores() {
        return this.cores;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer sockets() {
        return this.sockets;
    }

    public Integer totalVCpus() {
        return this.totalVCpus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cores() == null ? 0 : this.cores().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.sockets() == null ? 0 : this.sockets().hashCode());
        hashCode = 31 * hashCode + (this.totalVCpus() == null ? 0 : this.totalVCpus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostProperties)) {
            return false;
        }
        HostProperties other = (HostProperties)obj;
        if (other.cores() == null ^ this.cores() == null) {
            return false;
        }
        if (other.cores() != null && !other.cores().equals(this.cores())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.sockets() == null ^ this.sockets() == null) {
            return false;
        }
        if (other.sockets() != null && !other.sockets().equals(this.sockets())) {
            return false;
        }
        if (other.totalVCpus() == null ^ this.totalVCpus() == null) {
            return false;
        }
        return other.totalVCpus() == null || other.totalVCpus().equals(this.totalVCpus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cores() != null) {
            sb.append("Cores: ").append(this.cores()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.sockets() != null) {
            sb.append("Sockets: ").append(this.sockets()).append(",");
        }
        if (this.totalVCpus() != null) {
            sb.append("TotalVCpus: ").append(this.totalVCpus()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cores": {
                return Optional.of(clazz.cast(this.cores()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "Sockets": {
                return Optional.of(clazz.cast(this.sockets()));
            }
            case "TotalVCpus": {
                return Optional.of(clazz.cast(this.totalVCpus()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer cores;
        private String instanceType;
        private Integer sockets;
        private Integer totalVCpus;

        private BuilderImpl() {
        }

        private BuilderImpl(HostProperties model) {
            this.cores(model.cores);
            this.instanceType(model.instanceType);
            this.sockets(model.sockets);
            this.totalVCpus(model.totalVCpus);
        }

        public final Integer getCores() {
            return this.cores;
        }

        @Override
        public final Builder cores(Integer cores) {
            this.cores = cores;
            return this;
        }

        public final void setCores(Integer cores) {
            this.cores = cores;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getSockets() {
            return this.sockets;
        }

        @Override
        public final Builder sockets(Integer sockets) {
            this.sockets = sockets;
            return this;
        }

        public final void setSockets(Integer sockets) {
            this.sockets = sockets;
        }

        public final Integer getTotalVCpus() {
            return this.totalVCpus;
        }

        @Override
        public final Builder totalVCpus(Integer totalVCpus) {
            this.totalVCpus = totalVCpus;
            return this;
        }

        public final void setTotalVCpus(Integer totalVCpus) {
            this.totalVCpus = totalVCpus;
        }

        public HostProperties build() {
            return new HostProperties(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HostProperties> {
        public Builder cores(Integer var1);

        public Builder instanceType(String var1);

        public Builder sockets(Integer var1);

        public Builder totalVCpus(Integer var1);
    }
}

