/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.VpnConnection;
import software.amazon.awssdk.services.ec2.model.VpnConnectionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpnConnectionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVpnConnectionsResponse> {
    private final List<VpnConnection> vpnConnections;

    private DescribeVpnConnectionsResponse(BuilderImpl builder) {
        this.vpnConnections = builder.vpnConnections;
    }

    public List<VpnConnection> vpnConnections() {
        return this.vpnConnections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.vpnConnections() == null ? 0 : this.vpnConnections().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsResponse)) {
            return false;
        }
        DescribeVpnConnectionsResponse other = (DescribeVpnConnectionsResponse)((Object)obj);
        if (other.vpnConnections() == null ^ this.vpnConnections() == null) {
            return false;
        }
        return other.vpnConnections() == null || other.vpnConnections().equals(this.vpnConnections());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.vpnConnections() != null) {
            sb.append("VpnConnections: ").append(this.vpnConnections()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnConnections": {
                return Optional.of(clazz.cast(this.vpnConnections()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<VpnConnection> vpnConnections;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConnectionsResponse model) {
            this.vpnConnections(model.vpnConnections);
        }

        public final Collection<VpnConnection.Builder> getVpnConnections() {
            return this.vpnConnections != null ? (Collection)this.vpnConnections.stream().map(VpnConnection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpnConnections(Collection<VpnConnection> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copy(vpnConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnections(VpnConnection ... vpnConnections) {
            this.vpnConnections(Arrays.asList(vpnConnections));
            return this;
        }

        public final void setVpnConnections(Collection<VpnConnection.BuilderImpl> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copyFromBuilder(vpnConnections);
        }

        public DescribeVpnConnectionsResponse build() {
            return new DescribeVpnConnectionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpnConnectionsResponse> {
        public Builder vpnConnections(Collection<VpnConnection> var1);

        public Builder vpnConnections(VpnConnection ... var1);
    }
}

