/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailabilitySetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledInstanceAvailabilityResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityResponse> {
    private final String nextToken;
    private final List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet;

    private DescribeScheduledInstanceAvailabilityResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.scheduledInstanceAvailabilitySet = builder.scheduledInstanceAvailabilitySet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet() {
        return this.scheduledInstanceAvailabilitySet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.scheduledInstanceAvailabilitySet() == null ? 0 : this.scheduledInstanceAvailabilitySet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityResponse)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityResponse other = (DescribeScheduledInstanceAvailabilityResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.scheduledInstanceAvailabilitySet() == null ^ this.scheduledInstanceAvailabilitySet() == null) {
            return false;
        }
        return other.scheduledInstanceAvailabilitySet() == null || other.scheduledInstanceAvailabilitySet().equals(this.scheduledInstanceAvailabilitySet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.scheduledInstanceAvailabilitySet() != null) {
            sb.append("ScheduledInstanceAvailabilitySet: ").append(this.scheduledInstanceAvailabilitySet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "ScheduledInstanceAvailabilitySet": {
                return Optional.of(clazz.cast(this.scheduledInstanceAvailabilitySet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstanceAvailabilityResponse model) {
            this.nextToken(model.nextToken);
            this.scheduledInstanceAvailabilitySet(model.scheduledInstanceAvailabilitySet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ScheduledInstanceAvailability.Builder> getScheduledInstanceAvailabilitySet() {
            return this.scheduledInstanceAvailabilitySet != null ? (Collection)this.scheduledInstanceAvailabilitySet.stream().map(ScheduledInstanceAvailability::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet = ScheduledInstanceAvailabilitySetCopier.copy(scheduledInstanceAvailabilitySet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceAvailabilitySet(ScheduledInstanceAvailability ... scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet(Arrays.asList(scheduledInstanceAvailabilitySet));
            return this;
        }

        public final void setScheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability.BuilderImpl> scheduledInstanceAvailabilitySet) {
            this.scheduledInstanceAvailabilitySet = ScheduledInstanceAvailabilitySetCopier.copyFromBuilder(scheduledInstanceAvailabilitySet);
        }

        public DescribeScheduledInstanceAvailabilityResponse build() {
            return new DescribeScheduledInstanceAvailabilityResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityResponse> {
        public Builder nextToken(String var1);

        public Builder scheduledInstanceAvailabilitySet(Collection<ScheduledInstanceAvailability> var1);

        public Builder scheduledInstanceAvailabilitySet(ScheduledInstanceAvailability ... var1);
    }
}

