/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNetworkInterfaceAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeNetworkInterfaceAttributeRequest> {
    private final String attribute;
    private final String networkInterfaceId;

    private DescribeNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    public NetworkInterfaceAttribute attribute() {
        return NetworkInterfaceAttribute.fromValue(this.attribute);
    }

    public String attributeString() {
        return this.attribute;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributeString() == null ? 0 : this.attributeString().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfaceAttributeRequest)) {
            return false;
        }
        DescribeNetworkInterfaceAttributeRequest other = (DescribeNetworkInterfaceAttributeRequest)((Object)obj);
        if (other.attributeString() == null ^ this.attributeString() == null) {
            return false;
        }
        if (other.attributeString() != null && !other.attributeString().equals(this.attributeString())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        return other.networkInterfaceId() == null || other.networkInterfaceId().equals(this.networkInterfaceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attributeString() != null) {
            sb.append("Attribute: ").append(this.attributeString()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.of(clazz.cast(this.attributeString()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfaceAttributeRequest model) {
            this.attribute(model.attribute);
            this.networkInterfaceId(model.networkInterfaceId);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(NetworkInterfaceAttribute attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public DescribeNetworkInterfaceAttributeRequest build() {
            return new DescribeNetworkInterfaceAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNetworkInterfaceAttributeRequest> {
        public Builder attribute(String var1);

        public Builder attribute(NetworkInterfaceAttribute var1);

        public Builder networkInterfaceId(String var1);
    }
}

