/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.NatGateway;
import software.amazon.awssdk.services.ec2.model.NatGatewayListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNatGatewaysResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeNatGatewaysResponse> {
    private final List<NatGateway> natGateways;
    private final String nextToken;

    private DescribeNatGatewaysResponse(BuilderImpl builder) {
        this.natGateways = builder.natGateways;
        this.nextToken = builder.nextToken;
    }

    public List<NatGateway> natGateways() {
        return this.natGateways;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.natGateways() == null ? 0 : this.natGateways().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNatGatewaysResponse)) {
            return false;
        }
        DescribeNatGatewaysResponse other = (DescribeNatGatewaysResponse)((Object)obj);
        if (other.natGateways() == null ^ this.natGateways() == null) {
            return false;
        }
        if (other.natGateways() != null && !other.natGateways().equals(this.natGateways())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.natGateways() != null) {
            sb.append("NatGateways: ").append(this.natGateways()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NatGateways": {
                return Optional.of(clazz.cast(this.natGateways()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<NatGateway> natGateways;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNatGatewaysResponse model) {
            this.natGateways(model.natGateways);
            this.nextToken(model.nextToken);
        }

        public final Collection<NatGateway.Builder> getNatGateways() {
            return this.natGateways != null ? (Collection)this.natGateways.stream().map(NatGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder natGateways(Collection<NatGateway> natGateways) {
            this.natGateways = NatGatewayListCopier.copy(natGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGateways(NatGateway ... natGateways) {
            this.natGateways(Arrays.asList(natGateways));
            return this;
        }

        public final void setNatGateways(Collection<NatGateway.BuilderImpl> natGateways) {
            this.natGateways = NatGatewayListCopier.copyFromBuilder(natGateways);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeNatGatewaysResponse build() {
            return new DescribeNatGatewaysResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNatGatewaysResponse> {
        public Builder natGateways(Collection<NatGateway> var1);

        public Builder natGateways(NatGateway ... var1);

        public Builder nextToken(String var1);
    }
}

