/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotTask;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotTaskListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeImportSnapshotTasksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeImportSnapshotTasksResponse> {
    private final List<ImportSnapshotTask> importSnapshotTasks;
    private final String nextToken;

    private DescribeImportSnapshotTasksResponse(BuilderImpl builder) {
        this.importSnapshotTasks = builder.importSnapshotTasks;
        this.nextToken = builder.nextToken;
    }

    public List<ImportSnapshotTask> importSnapshotTasks() {
        return this.importSnapshotTasks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.importSnapshotTasks() == null ? 0 : this.importSnapshotTasks().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportSnapshotTasksResponse)) {
            return false;
        }
        DescribeImportSnapshotTasksResponse other = (DescribeImportSnapshotTasksResponse)((Object)obj);
        if (other.importSnapshotTasks() == null ^ this.importSnapshotTasks() == null) {
            return false;
        }
        if (other.importSnapshotTasks() != null && !other.importSnapshotTasks().equals(this.importSnapshotTasks())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.importSnapshotTasks() != null) {
            sb.append("ImportSnapshotTasks: ").append(this.importSnapshotTasks()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportSnapshotTasks": {
                return Optional.of(clazz.cast(this.importSnapshotTasks()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ImportSnapshotTask> importSnapshotTasks;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportSnapshotTasksResponse model) {
            this.importSnapshotTasks(model.importSnapshotTasks);
            this.nextToken(model.nextToken);
        }

        public final Collection<ImportSnapshotTask.Builder> getImportSnapshotTasks() {
            return this.importSnapshotTasks != null ? (Collection)this.importSnapshotTasks.stream().map(ImportSnapshotTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder importSnapshotTasks(Collection<ImportSnapshotTask> importSnapshotTasks) {
            this.importSnapshotTasks = ImportSnapshotTaskListCopier.copy(importSnapshotTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSnapshotTasks(ImportSnapshotTask ... importSnapshotTasks) {
            this.importSnapshotTasks(Arrays.asList(importSnapshotTasks));
            return this;
        }

        public final void setImportSnapshotTasks(Collection<ImportSnapshotTask.BuilderImpl> importSnapshotTasks) {
            this.importSnapshotTasks = ImportSnapshotTaskListCopier.copyFromBuilder(importSnapshotTasks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeImportSnapshotTasksResponse build() {
            return new DescribeImportSnapshotTasksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeImportSnapshotTasksResponse> {
        public Builder importSnapshotTasks(Collection<ImportSnapshotTask> var1);

        public Builder importSnapshotTasks(ImportSnapshotTask ... var1);

        public Builder nextToken(String var1);
    }
}

