/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteRouteRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteRouteRequest> {
    private final String destinationCidrBlock;
    private final String destinationIpv6CidrBlock;
    private final String routeTableId;

    private DeleteRouteRequest(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.routeTableId = builder.routeTableId;
    }

    public String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public String destinationIpv6CidrBlock() {
        return this.destinationIpv6CidrBlock;
    }

    public String routeTableId() {
        return this.routeTableId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.destinationCidrBlock() == null ? 0 : this.destinationCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.destinationIpv6CidrBlock() == null ? 0 : this.destinationIpv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.routeTableId() == null ? 0 : this.routeTableId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRouteRequest)) {
            return false;
        }
        DeleteRouteRequest other = (DeleteRouteRequest)((Object)obj);
        if (other.destinationCidrBlock() == null ^ this.destinationCidrBlock() == null) {
            return false;
        }
        if (other.destinationCidrBlock() != null && !other.destinationCidrBlock().equals(this.destinationCidrBlock())) {
            return false;
        }
        if (other.destinationIpv6CidrBlock() == null ^ this.destinationIpv6CidrBlock() == null) {
            return false;
        }
        if (other.destinationIpv6CidrBlock() != null && !other.destinationIpv6CidrBlock().equals(this.destinationIpv6CidrBlock())) {
            return false;
        }
        if (other.routeTableId() == null ^ this.routeTableId() == null) {
            return false;
        }
        return other.routeTableId() == null || other.routeTableId().equals(this.routeTableId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.destinationCidrBlock() != null) {
            sb.append("DestinationCidrBlock: ").append(this.destinationCidrBlock()).append(",");
        }
        if (this.destinationIpv6CidrBlock() != null) {
            sb.append("DestinationIpv6CidrBlock: ").append(this.destinationIpv6CidrBlock()).append(",");
        }
        if (this.routeTableId() != null) {
            sb.append("RouteTableId: ").append(this.routeTableId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.of(clazz.cast(this.destinationCidrBlock()));
            }
            case "DestinationIpv6CidrBlock": {
                return Optional.of(clazz.cast(this.destinationIpv6CidrBlock()));
            }
            case "RouteTableId": {
                return Optional.of(clazz.cast(this.routeTableId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String destinationIpv6CidrBlock;
        private String routeTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRouteRequest model) {
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            this.routeTableId(model.routeTableId);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getDestinationIpv6CidrBlock() {
            return this.destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public DeleteRouteRequest build() {
            return new DeleteRouteRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteRouteRequest> {
        public Builder destinationCidrBlock(String var1);

        public Builder destinationIpv6CidrBlock(String var1);

        public Builder routeTableId(String var1);
    }
}

