/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpPermissionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AuthorizeSecurityGroupIngressRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AuthorizeSecurityGroupIngressRequest> {
    private final String cidrIp;
    private final Integer fromPort;
    private final String groupId;
    private final String groupName;
    private final List<IpPermission> ipPermissions;
    private final String ipProtocol;
    private final String sourceSecurityGroupName;
    private final String sourceSecurityGroupOwnerId;
    private final Integer toPort;

    private AuthorizeSecurityGroupIngressRequest(BuilderImpl builder) {
        this.cidrIp = builder.cidrIp;
        this.fromPort = builder.fromPort;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.ipPermissions = builder.ipPermissions;
        this.ipProtocol = builder.ipProtocol;
        this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
        this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
        this.toPort = builder.toPort;
    }

    public String cidrIp() {
        return this.cidrIp;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public String groupId() {
        return this.groupId;
    }

    public String groupName() {
        return this.groupName;
    }

    public List<IpPermission> ipPermissions() {
        return this.ipPermissions;
    }

    public String ipProtocol() {
        return this.ipProtocol;
    }

    public String sourceSecurityGroupName() {
        return this.sourceSecurityGroupName;
    }

    public String sourceSecurityGroupOwnerId() {
        return this.sourceSecurityGroupOwnerId;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cidrIp() == null ? 0 : this.cidrIp().hashCode());
        hashCode = 31 * hashCode + (this.fromPort() == null ? 0 : this.fromPort().hashCode());
        hashCode = 31 * hashCode + (this.groupId() == null ? 0 : this.groupId().hashCode());
        hashCode = 31 * hashCode + (this.groupName() == null ? 0 : this.groupName().hashCode());
        hashCode = 31 * hashCode + (this.ipPermissions() == null ? 0 : this.ipPermissions().hashCode());
        hashCode = 31 * hashCode + (this.ipProtocol() == null ? 0 : this.ipProtocol().hashCode());
        hashCode = 31 * hashCode + (this.sourceSecurityGroupName() == null ? 0 : this.sourceSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.sourceSecurityGroupOwnerId() == null ? 0 : this.sourceSecurityGroupOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.toPort() == null ? 0 : this.toPort().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSecurityGroupIngressRequest)) {
            return false;
        }
        AuthorizeSecurityGroupIngressRequest other = (AuthorizeSecurityGroupIngressRequest)((Object)obj);
        if (other.cidrIp() == null ^ this.cidrIp() == null) {
            return false;
        }
        if (other.cidrIp() != null && !other.cidrIp().equals(this.cidrIp())) {
            return false;
        }
        if (other.fromPort() == null ^ this.fromPort() == null) {
            return false;
        }
        if (other.fromPort() != null && !other.fromPort().equals(this.fromPort())) {
            return false;
        }
        if (other.groupId() == null ^ this.groupId() == null) {
            return false;
        }
        if (other.groupId() != null && !other.groupId().equals(this.groupId())) {
            return false;
        }
        if (other.groupName() == null ^ this.groupName() == null) {
            return false;
        }
        if (other.groupName() != null && !other.groupName().equals(this.groupName())) {
            return false;
        }
        if (other.ipPermissions() == null ^ this.ipPermissions() == null) {
            return false;
        }
        if (other.ipPermissions() != null && !other.ipPermissions().equals(this.ipPermissions())) {
            return false;
        }
        if (other.ipProtocol() == null ^ this.ipProtocol() == null) {
            return false;
        }
        if (other.ipProtocol() != null && !other.ipProtocol().equals(this.ipProtocol())) {
            return false;
        }
        if (other.sourceSecurityGroupName() == null ^ this.sourceSecurityGroupName() == null) {
            return false;
        }
        if (other.sourceSecurityGroupName() != null && !other.sourceSecurityGroupName().equals(this.sourceSecurityGroupName())) {
            return false;
        }
        if (other.sourceSecurityGroupOwnerId() == null ^ this.sourceSecurityGroupOwnerId() == null) {
            return false;
        }
        if (other.sourceSecurityGroupOwnerId() != null && !other.sourceSecurityGroupOwnerId().equals(this.sourceSecurityGroupOwnerId())) {
            return false;
        }
        if (other.toPort() == null ^ this.toPort() == null) {
            return false;
        }
        return other.toPort() == null || other.toPort().equals(this.toPort());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cidrIp() != null) {
            sb.append("CidrIp: ").append(this.cidrIp()).append(",");
        }
        if (this.fromPort() != null) {
            sb.append("FromPort: ").append(this.fromPort()).append(",");
        }
        if (this.groupId() != null) {
            sb.append("GroupId: ").append(this.groupId()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.ipPermissions() != null) {
            sb.append("IpPermissions: ").append(this.ipPermissions()).append(",");
        }
        if (this.ipProtocol() != null) {
            sb.append("IpProtocol: ").append(this.ipProtocol()).append(",");
        }
        if (this.sourceSecurityGroupName() != null) {
            sb.append("SourceSecurityGroupName: ").append(this.sourceSecurityGroupName()).append(",");
        }
        if (this.sourceSecurityGroupOwnerId() != null) {
            sb.append("SourceSecurityGroupOwnerId: ").append(this.sourceSecurityGroupOwnerId()).append(",");
        }
        if (this.toPort() != null) {
            sb.append("ToPort: ").append(this.toPort()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrIp": {
                return Optional.of(clazz.cast(this.cidrIp()));
            }
            case "FromPort": {
                return Optional.of(clazz.cast(this.fromPort()));
            }
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "IpPermissions": {
                return Optional.of(clazz.cast(this.ipPermissions()));
            }
            case "IpProtocol": {
                return Optional.of(clazz.cast(this.ipProtocol()));
            }
            case "SourceSecurityGroupName": {
                return Optional.of(clazz.cast(this.sourceSecurityGroupName()));
            }
            case "SourceSecurityGroupOwnerId": {
                return Optional.of(clazz.cast(this.sourceSecurityGroupOwnerId()));
            }
            case "ToPort": {
                return Optional.of(clazz.cast(this.toPort()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cidrIp;
        private Integer fromPort;
        private String groupId;
        private String groupName;
        private List<IpPermission> ipPermissions;
        private String ipProtocol;
        private String sourceSecurityGroupName;
        private String sourceSecurityGroupOwnerId;
        private Integer toPort;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeSecurityGroupIngressRequest model) {
            this.cidrIp(model.cidrIp);
            this.fromPort(model.fromPort);
            this.groupId(model.groupId);
            this.groupName(model.groupName);
            this.ipPermissions(model.ipPermissions);
            this.ipProtocol(model.ipProtocol);
            this.sourceSecurityGroupName(model.sourceSecurityGroupName);
            this.sourceSecurityGroupOwnerId(model.sourceSecurityGroupOwnerId);
            this.toPort(model.toPort);
        }

        public final String getCidrIp() {
            return this.cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<IpPermission.Builder> getIpPermissions() {
            return this.ipPermissions != null ? (Collection)this.ipPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission ... ipPermissions) {
            this.ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        public final String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final String getSourceSecurityGroupName() {
            return this.sourceSecurityGroupName;
        }

        @Override
        public final Builder sourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
            return this;
        }

        public final void setSourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
        }

        public final String getSourceSecurityGroupOwnerId() {
            return this.sourceSecurityGroupOwnerId;
        }

        @Override
        public final Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
            return this;
        }

        public final void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public AuthorizeSecurityGroupIngressRequest build() {
            return new AuthorizeSecurityGroupIngressRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AuthorizeSecurityGroupIngressRequest> {
        public Builder cidrIp(String var1);

        public Builder fromPort(Integer var1);

        public Builder groupId(String var1);

        public Builder groupName(String var1);

        public Builder ipPermissions(Collection<IpPermission> var1);

        public Builder ipPermissions(IpPermission ... var1);

        public Builder ipProtocol(String var1);

        public Builder sourceSecurityGroupName(String var1);

        public Builder sourceSecurityGroupOwnerId(String var1);

        public Builder toPort(Integer var1);
    }
}

