/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest;
import software.amazon.awssdk.util.StringUtils;

public class UnassignIpv6AddressesRequestMarshaller
implements Marshaller<Request<UnassignIpv6AddressesRequest>, UnassignIpv6AddressesRequest> {
    public Request<UnassignIpv6AddressesRequest> marshall(UnassignIpv6AddressesRequest unassignIpv6AddressesRequest) {
        if (unassignIpv6AddressesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)unassignIpv6AddressesRequest, "EC2Client");
        request.addParameter("Action", "UnassignIpv6Addresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> unassignIpv6AddressesRequestIpv6AddressesList = unassignIpv6AddressesRequest.ipv6Addresses();
        if (unassignIpv6AddressesRequestIpv6AddressesList != null) {
            int ipv6AddressesListIndex = 1;
            for (String unassignIpv6AddressesRequestIpv6AddressesListValue : unassignIpv6AddressesRequestIpv6AddressesList) {
                if (unassignIpv6AddressesRequestIpv6AddressesListValue != null) {
                    request.addParameter("Ipv6Addresses." + ipv6AddressesListIndex, StringUtils.fromString((String)unassignIpv6AddressesRequestIpv6AddressesListValue));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (unassignIpv6AddressesRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)unassignIpv6AddressesRequest.networkInterfaceId()));
        }
        return request;
    }
}

