/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.InstanceCapacity;

public class InstanceCapacityUnmarshaller
implements Unmarshaller<InstanceCapacity, StaxUnmarshallerContext> {
    private static final InstanceCapacityUnmarshaller INSTANCE = new InstanceCapacityUnmarshaller();

    public InstanceCapacity unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        InstanceCapacity.Builder instanceCapacity = InstanceCapacity.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("availableCapacity", targetDepth)) {
                    instanceCapacity.availableCapacity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceType", targetDepth)) {
                    instanceCapacity.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("totalCapacity", targetDepth)) continue;
                instanceCapacity.totalCapacity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (InstanceCapacity)instanceCapacity.build();
    }

    public static InstanceCapacityUnmarshaller getInstance() {
        return INSTANCE;
    }
}

