/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ImportKeyPairRequest;
import software.amazon.awssdk.util.StringUtils;

public class ImportKeyPairRequestMarshaller
implements Marshaller<Request<ImportKeyPairRequest>, ImportKeyPairRequest> {
    public Request<ImportKeyPairRequest> marshall(ImportKeyPairRequest importKeyPairRequest) {
        if (importKeyPairRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importKeyPairRequest, "EC2Client");
        request.addParameter("Action", "ImportKeyPair");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importKeyPairRequest.keyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString((String)importKeyPairRequest.keyName()));
        }
        if (importKeyPairRequest.publicKeyMaterial() != null) {
            request.addParameter("PublicKeyMaterial", StringUtils.fromString((String)importKeyPairRequest.publicKeyMaterial()));
        }
        return request;
    }
}

