/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;

public class GroupIdentifierUnmarshaller
implements Unmarshaller<GroupIdentifier, StaxUnmarshallerContext> {
    private static final GroupIdentifierUnmarshaller INSTANCE = new GroupIdentifierUnmarshaller();

    public GroupIdentifier unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        GroupIdentifier.Builder groupIdentifier = GroupIdentifier.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("groupName", targetDepth)) {
                    groupIdentifier.groupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("groupId", targetDepth)) continue;
                groupIdentifier.groupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (GroupIdentifier)groupIdentifier.build();
    }

    public static GroupIdentifierUnmarshaller getInstance() {
        return INSTANCE;
    }
}

