/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeImagesRequestMarshaller
implements Marshaller<Request<DescribeImagesRequest>, DescribeImagesRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<DescribeImagesRequest> marshall(DescribeImagesRequest describeImagesRequest) {
        List<String> list;
        List<String> describeImagesRequestImageIdsList;
        List<Filter> describeImagesRequestFiltersList;
        if (describeImagesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeImagesRequest, "EC2Client");
        request.addParameter("Action", "DescribeImages");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeImagesRequestExecutableUsersList = describeImagesRequest.executableUsers();
        if (describeImagesRequestExecutableUsersList != null) {
            int executableUsersListIndex = 1;
            for (String string : describeImagesRequestExecutableUsersList) {
                if (string != null) {
                    request.addParameter("ExecutableBy." + executableUsersListIndex, StringUtils.fromString((String)string));
                }
                ++executableUsersListIndex;
            }
        }
        if ((describeImagesRequestFiltersList = describeImagesRequest.filters()) != null) {
            int filtersListIndex = 1;
            for (Filter filter : describeImagesRequestFiltersList) {
                List<String> filterValuesList;
                if (filter.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filter.name()));
                }
                if ((filterValuesList = filter.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeImagesRequestImageIdsList = describeImagesRequest.imageIds()) != null) {
            boolean bl = true;
            for (String describeImagesRequestImageIdsListValue : describeImagesRequestImageIdsList) {
                void var6_12;
                if (describeImagesRequestImageIdsListValue != null) {
                    request.addParameter("ImageId." + (int)var6_12, StringUtils.fromString((String)describeImagesRequestImageIdsListValue));
                }
                ++var6_12;
            }
        }
        if ((list = describeImagesRequest.owners()) != null) {
            boolean bl = true;
            for (String describeImagesRequestOwnersListValue : list) {
                void var7_18;
                if (describeImagesRequestOwnersListValue != null) {
                    request.addParameter("Owner." + (int)var7_18, StringUtils.fromString((String)describeImagesRequestOwnersListValue));
                }
                ++var7_18;
            }
        }
        return request;
    }
}

