/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest;
import software.amazon.awssdk.util.StringUtils;

public class AttachNetworkInterfaceRequestMarshaller
implements Marshaller<Request<AttachNetworkInterfaceRequest>, AttachNetworkInterfaceRequest> {
    public Request<AttachNetworkInterfaceRequest> marshall(AttachNetworkInterfaceRequest attachNetworkInterfaceRequest) {
        if (attachNetworkInterfaceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachNetworkInterfaceRequest, "EC2Client");
        request.addParameter("Action", "AttachNetworkInterface");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachNetworkInterfaceRequest.deviceIndex() != null) {
            request.addParameter("DeviceIndex", StringUtils.fromInteger((Integer)attachNetworkInterfaceRequest.deviceIndex()));
        }
        if (attachNetworkInterfaceRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)attachNetworkInterfaceRequest.instanceId()));
        }
        if (attachNetworkInterfaceRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)attachNetworkInterfaceRequest.networkInterfaceId()));
        }
        return request;
    }
}

