/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ArchitectureValues;
import software.amazon.awssdk.services.ec2.model.BillingProductListCopier;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingRequestListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterImageRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RegisterImageRequest> {
    private final String imageLocation;
    private final String architecture;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String description;
    private final Boolean enaSupport;
    private final String kernelId;
    private final String name;
    private final List<String> billingProducts;
    private final String ramdiskId;
    private final String rootDeviceName;
    private final String sriovNetSupport;
    private final String virtualizationType;

    private RegisterImageRequest(BuilderImpl builder) {
        this.imageLocation = builder.imageLocation;
        this.architecture = builder.architecture;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.description = builder.description;
        this.enaSupport = builder.enaSupport;
        this.kernelId = builder.kernelId;
        this.name = builder.name;
        this.billingProducts = builder.billingProducts;
        this.ramdiskId = builder.ramdiskId;
        this.rootDeviceName = builder.rootDeviceName;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.virtualizationType = builder.virtualizationType;
    }

    public String imageLocation() {
        return this.imageLocation;
    }

    public String architecture() {
        return this.architecture;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String description() {
        return this.description;
    }

    public Boolean enaSupport() {
        return this.enaSupport;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String name() {
        return this.name;
    }

    public List<String> billingProducts() {
        return this.billingProducts;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String rootDeviceName() {
        return this.rootDeviceName;
    }

    public String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public String virtualizationType() {
        return this.virtualizationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.imageLocation() == null ? 0 : this.imageLocation().hashCode());
        hashCode = 31 * hashCode + (this.architecture() == null ? 0 : this.architecture().hashCode());
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.enaSupport() == null ? 0 : this.enaSupport().hashCode());
        hashCode = 31 * hashCode + (this.kernelId() == null ? 0 : this.kernelId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.billingProducts() == null ? 0 : this.billingProducts().hashCode());
        hashCode = 31 * hashCode + (this.ramdiskId() == null ? 0 : this.ramdiskId().hashCode());
        hashCode = 31 * hashCode + (this.rootDeviceName() == null ? 0 : this.rootDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.sriovNetSupport() == null ? 0 : this.sriovNetSupport().hashCode());
        hashCode = 31 * hashCode + (this.virtualizationType() == null ? 0 : this.virtualizationType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterImageRequest)) {
            return false;
        }
        RegisterImageRequest other = (RegisterImageRequest)((Object)obj);
        if (other.imageLocation() == null ^ this.imageLocation() == null) {
            return false;
        }
        if (other.imageLocation() != null && !other.imageLocation().equals(this.imageLocation())) {
            return false;
        }
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.enaSupport() == null ^ this.enaSupport() == null) {
            return false;
        }
        if (other.enaSupport() != null && !other.enaSupport().equals(this.enaSupport())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.billingProducts() == null ^ this.billingProducts() == null) {
            return false;
        }
        if (other.billingProducts() != null && !other.billingProducts().equals(this.billingProducts())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.rootDeviceName() == null ^ this.rootDeviceName() == null) {
            return false;
        }
        if (other.rootDeviceName() != null && !other.rootDeviceName().equals(this.rootDeviceName())) {
            return false;
        }
        if (other.sriovNetSupport() == null ^ this.sriovNetSupport() == null) {
            return false;
        }
        if (other.sriovNetSupport() != null && !other.sriovNetSupport().equals(this.sriovNetSupport())) {
            return false;
        }
        if (other.virtualizationType() == null ^ this.virtualizationType() == null) {
            return false;
        }
        return other.virtualizationType() == null || other.virtualizationType().equals(this.virtualizationType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageLocation() != null) {
            sb.append("ImageLocation: ").append(this.imageLocation()).append(",");
        }
        if (this.architecture() != null) {
            sb.append("Architecture: ").append(this.architecture()).append(",");
        }
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.enaSupport() != null) {
            sb.append("EnaSupport: ").append(this.enaSupport()).append(",");
        }
        if (this.kernelId() != null) {
            sb.append("KernelId: ").append(this.kernelId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.billingProducts() != null) {
            sb.append("BillingProducts: ").append(this.billingProducts()).append(",");
        }
        if (this.ramdiskId() != null) {
            sb.append("RamdiskId: ").append(this.ramdiskId()).append(",");
        }
        if (this.rootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(this.rootDeviceName()).append(",");
        }
        if (this.sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(this.sriovNetSupport()).append(",");
        }
        if (this.virtualizationType() != null) {
            sb.append("VirtualizationType: ").append(this.virtualizationType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String imageLocation;
        private String architecture;
        private List<BlockDeviceMapping> blockDeviceMappings;
        private String description;
        private Boolean enaSupport;
        private String kernelId;
        private String name;
        private List<String> billingProducts;
        private String ramdiskId;
        private String rootDeviceName;
        private String sriovNetSupport;
        private String virtualizationType;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterImageRequest model) {
            this.setImageLocation(model.imageLocation);
            this.setArchitecture(model.architecture);
            this.setBlockDeviceMappings(model.blockDeviceMappings);
            this.setDescription(model.description);
            this.setEnaSupport(model.enaSupport);
            this.setKernelId(model.kernelId);
            this.setName(model.name);
            this.setBillingProducts(model.billingProducts);
            this.setRamdiskId(model.ramdiskId);
            this.setRootDeviceName(model.rootDeviceName);
            this.setSriovNetSupport(model.sriovNetSupport);
            this.setVirtualizationType(model.virtualizationType);
        }

        public final String getImageLocation() {
            return this.imageLocation;
        }

        @Override
        public final Builder imageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
            return this;
        }

        public final void setImageLocation(String imageLocation) {
            this.imageLocation = imageLocation;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnaSupport() {
            return this.enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getBillingProducts() {
            return this.billingProducts;
        }

        @Override
        public final Builder billingProducts(Collection<String> billingProducts) {
            this.billingProducts = BillingProductListCopier.copy(billingProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingProducts(String ... billingProducts) {
            this.billingProducts(Arrays.asList(billingProducts));
            return this;
        }

        public final void setBillingProducts(Collection<String> billingProducts) {
            this.billingProducts = BillingProductListCopier.copy(billingProducts);
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getRootDeviceName() {
            return this.rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final String getVirtualizationType() {
            return this.virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        public RegisterImageRequest build() {
            return new RegisterImageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterImageRequest> {
        public Builder imageLocation(String var1);

        public Builder architecture(String var1);

        public Builder architecture(ArchitectureValues var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder description(String var1);

        public Builder enaSupport(Boolean var1);

        public Builder kernelId(String var1);

        public Builder name(String var1);

        public Builder billingProducts(Collection<String> var1);

        public Builder billingProducts(String ... var1);

        public Builder ramdiskId(String var1);

        public Builder rootDeviceName(String var1);

        public Builder sriovNetSupport(String var1);

        public Builder virtualizationType(String var1);
    }
}

