/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PciId
implements ToCopyableBuilder<Builder, PciId> {
    private final String deviceId;
    private final String vendorId;
    private final String subsystemId;
    private final String subsystemVendorId;

    private PciId(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.vendorId = builder.vendorId;
        this.subsystemId = builder.subsystemId;
        this.subsystemVendorId = builder.subsystemVendorId;
    }

    public String deviceId() {
        return this.deviceId;
    }

    public String vendorId() {
        return this.vendorId;
    }

    public String subsystemId() {
        return this.subsystemId;
    }

    public String subsystemVendorId() {
        return this.subsystemVendorId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deviceId() == null ? 0 : this.deviceId().hashCode());
        hashCode = 31 * hashCode + (this.vendorId() == null ? 0 : this.vendorId().hashCode());
        hashCode = 31 * hashCode + (this.subsystemId() == null ? 0 : this.subsystemId().hashCode());
        hashCode = 31 * hashCode + (this.subsystemVendorId() == null ? 0 : this.subsystemVendorId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PciId)) {
            return false;
        }
        PciId other = (PciId)obj;
        if (other.deviceId() == null ^ this.deviceId() == null) {
            return false;
        }
        if (other.deviceId() != null && !other.deviceId().equals(this.deviceId())) {
            return false;
        }
        if (other.vendorId() == null ^ this.vendorId() == null) {
            return false;
        }
        if (other.vendorId() != null && !other.vendorId().equals(this.vendorId())) {
            return false;
        }
        if (other.subsystemId() == null ^ this.subsystemId() == null) {
            return false;
        }
        if (other.subsystemId() != null && !other.subsystemId().equals(this.subsystemId())) {
            return false;
        }
        if (other.subsystemVendorId() == null ^ this.subsystemVendorId() == null) {
            return false;
        }
        return other.subsystemVendorId() == null || other.subsystemVendorId().equals(this.subsystemVendorId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deviceId() != null) {
            sb.append("DeviceId: ").append(this.deviceId()).append(",");
        }
        if (this.vendorId() != null) {
            sb.append("VendorId: ").append(this.vendorId()).append(",");
        }
        if (this.subsystemId() != null) {
            sb.append("SubsystemId: ").append(this.subsystemId()).append(",");
        }
        if (this.subsystemVendorId() != null) {
            sb.append("SubsystemVendorId: ").append(this.subsystemVendorId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String deviceId;
        private String vendorId;
        private String subsystemId;
        private String subsystemVendorId;

        private BuilderImpl() {
        }

        private BuilderImpl(PciId model) {
            this.setDeviceId(model.deviceId);
            this.setVendorId(model.vendorId);
            this.setSubsystemId(model.subsystemId);
            this.setSubsystemVendorId(model.subsystemVendorId);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final String getVendorId() {
            return this.vendorId;
        }

        @Override
        public final Builder vendorId(String vendorId) {
            this.vendorId = vendorId;
            return this;
        }

        public final void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        public final String getSubsystemId() {
            return this.subsystemId;
        }

        @Override
        public final Builder subsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
            return this;
        }

        public final void setSubsystemId(String subsystemId) {
            this.subsystemId = subsystemId;
        }

        public final String getSubsystemVendorId() {
            return this.subsystemVendorId;
        }

        @Override
        public final Builder subsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
            return this;
        }

        public final void setSubsystemVendorId(String subsystemVendorId) {
            this.subsystemVendorId = subsystemVendorId;
        }

        public PciId build() {
            return new PciId(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PciId> {
        public Builder deviceId(String var1);

        public Builder vendorId(String var1);

        public Builder subsystemId(String var1);

        public Builder subsystemVendorId(String var1);
    }
}

