/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInternetGatewaysRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeInternetGatewaysRequest> {
    private final List<Filter> filters;
    private final List<String> internetGatewayIds;

    private DescribeInternetGatewaysRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.internetGatewayIds = builder.internetGatewayIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> internetGatewayIds() {
        return this.internetGatewayIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.internetGatewayIds() == null ? 0 : this.internetGatewayIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInternetGatewaysRequest)) {
            return false;
        }
        DescribeInternetGatewaysRequest other = (DescribeInternetGatewaysRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.internetGatewayIds() == null ^ this.internetGatewayIds() == null) {
            return false;
        }
        return other.internetGatewayIds() == null || other.internetGatewayIds().equals(this.internetGatewayIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.internetGatewayIds() != null) {
            sb.append("InternetGatewayIds: ").append(this.internetGatewayIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> internetGatewayIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInternetGatewaysRequest model) {
            this.setFilters(model.filters);
            this.setInternetGatewayIds(model.internetGatewayIds);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Collection<String> getInternetGatewayIds() {
            return this.internetGatewayIds;
        }

        @Override
        public final Builder internetGatewayIds(Collection<String> internetGatewayIds) {
            this.internetGatewayIds = ValueStringListCopier.copy(internetGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder internetGatewayIds(String ... internetGatewayIds) {
            this.internetGatewayIds(Arrays.asList(internetGatewayIds));
            return this;
        }

        public final void setInternetGatewayIds(Collection<String> internetGatewayIds) {
            this.internetGatewayIds = ValueStringListCopier.copy(internetGatewayIds);
        }

        public DescribeInternetGatewaysRequest build() {
            return new DescribeInternetGatewaysRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInternetGatewaysRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder internetGatewayIds(Collection<String> var1);

        public Builder internetGatewayIds(String ... var1);
    }
}

