/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequestIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelSpotInstanceRequestsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CancelSpotInstanceRequestsRequest> {
    private final List<String> spotInstanceRequestIds;

    private CancelSpotInstanceRequestsRequest(BuilderImpl builder) {
        this.spotInstanceRequestIds = builder.spotInstanceRequestIds;
    }

    public List<String> spotInstanceRequestIds() {
        return this.spotInstanceRequestIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.spotInstanceRequestIds() == null ? 0 : this.spotInstanceRequestIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotInstanceRequestsRequest)) {
            return false;
        }
        CancelSpotInstanceRequestsRequest other = (CancelSpotInstanceRequestsRequest)((Object)obj);
        if (other.spotInstanceRequestIds() == null ^ this.spotInstanceRequestIds() == null) {
            return false;
        }
        return other.spotInstanceRequestIds() == null || other.spotInstanceRequestIds().equals(this.spotInstanceRequestIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.spotInstanceRequestIds() != null) {
            sb.append("SpotInstanceRequestIds: ").append(this.spotInstanceRequestIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> spotInstanceRequestIds;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotInstanceRequestsRequest model) {
            this.setSpotInstanceRequestIds(model.spotInstanceRequestIds);
        }

        public final Collection<String> getSpotInstanceRequestIds() {
            return this.spotInstanceRequestIds;
        }

        @Override
        public final Builder spotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequestIds(String ... spotInstanceRequestIds) {
            this.spotInstanceRequestIds(Arrays.asList(spotInstanceRequestIds));
            return this;
        }

        public final void setSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
            this.spotInstanceRequestIds = SpotInstanceRequestIdListCopier.copy(spotInstanceRequestIds);
        }

        public CancelSpotInstanceRequestsRequest build() {
            return new CancelSpotInstanceRequestsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CancelSpotInstanceRequestsRequest> {
        public Builder spotInstanceRequestIds(Collection<String> var1);

        public Builder spotInstanceRequestIds(String ... var1);
    }
}

