/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest;
import software.amazon.awssdk.services.ec2.waiters.BundleTaskComplete;
import software.amazon.awssdk.services.ec2.waiters.ConversionTaskCancelled;
import software.amazon.awssdk.services.ec2.waiters.ConversionTaskCompleted;
import software.amazon.awssdk.services.ec2.waiters.ConversionTaskDeleted;
import software.amazon.awssdk.services.ec2.waiters.CustomerGatewayAvailable;
import software.amazon.awssdk.services.ec2.waiters.DescribeBundleTasksFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeConversionTasksFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeCustomerGatewaysFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeExportTasksFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeImagesFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeInstanceStatusFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeInstancesFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeKeyPairsFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeNatGatewaysFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeNetworkInterfacesFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeSnapshotsFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeSpotInstanceRequestsFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeSubnetsFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeVolumesFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeVpcPeeringConnectionsFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeVpcsFunction;
import software.amazon.awssdk.services.ec2.waiters.DescribeVpnConnectionsFunction;
import software.amazon.awssdk.services.ec2.waiters.ExportTaskCancelled;
import software.amazon.awssdk.services.ec2.waiters.ExportTaskCompleted;
import software.amazon.awssdk.services.ec2.waiters.GetPasswordDataFunction;
import software.amazon.awssdk.services.ec2.waiters.ImageAvailable;
import software.amazon.awssdk.services.ec2.waiters.ImageExists;
import software.amazon.awssdk.services.ec2.waiters.InstanceExists;
import software.amazon.awssdk.services.ec2.waiters.InstanceRunning;
import software.amazon.awssdk.services.ec2.waiters.InstanceStatusOk;
import software.amazon.awssdk.services.ec2.waiters.InstanceStopped;
import software.amazon.awssdk.services.ec2.waiters.InstanceTerminated;
import software.amazon.awssdk.services.ec2.waiters.KeyPairExists;
import software.amazon.awssdk.services.ec2.waiters.NatGatewayAvailable;
import software.amazon.awssdk.services.ec2.waiters.NetworkInterfaceAvailable;
import software.amazon.awssdk.services.ec2.waiters.PasswordDataAvailable;
import software.amazon.awssdk.services.ec2.waiters.SnapshotCompleted;
import software.amazon.awssdk.services.ec2.waiters.SpotInstanceRequestFulfilled;
import software.amazon.awssdk.services.ec2.waiters.SubnetAvailable;
import software.amazon.awssdk.services.ec2.waiters.SystemStatusOk;
import software.amazon.awssdk.services.ec2.waiters.VolumeAvailable;
import software.amazon.awssdk.services.ec2.waiters.VolumeDeleted;
import software.amazon.awssdk.services.ec2.waiters.VolumeInUse;
import software.amazon.awssdk.services.ec2.waiters.VpcAvailable;
import software.amazon.awssdk.services.ec2.waiters.VpcExists;
import software.amazon.awssdk.services.ec2.waiters.VpcPeeringConnectionDeleted;
import software.amazon.awssdk.services.ec2.waiters.VpcPeeringConnectionExists;
import software.amazon.awssdk.services.ec2.waiters.VpnConnectionAvailable;
import software.amazon.awssdk.services.ec2.waiters.VpnConnectionDeleted;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.HttpSuccessStatusAcceptor;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;
import software.amazon.awssdk.waiters.WaiterState;

public class EC2ClientWaiters {
    private final EC2Client client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public EC2ClientWaiters(EC2Client client) {
        this.client = client;
    }

    public Waiter<GetPasswordDataRequest> passwordDataAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetPasswordDataFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new PasswordDataAvailable.IsTrueMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeVolumesRequest> volumeInUse() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVolumesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VolumeInUse.IsInuseMatcher(), new VolumeInUse.IsDeletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeImagesRequest> imageAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeImagesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ImageAvailable.IsAvailableMatcher(), new ImageAvailable.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNetworkInterfacesRequest> networkInterfaceAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNetworkInterfacesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NetworkInterfaceAvailable.IsAvailableMatcher(), new NetworkInterfaceAvailable.IsInvalidNetworkInterfaceIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(10), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstanceStatusRequest> systemStatusOk() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstanceStatusFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new SystemStatusOk.IsOkMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeVpcPeeringConnectionsRequest> vpcPeeringConnectionExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVpcPeeringConnectionsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new VpcPeeringConnectionExists.IsInvalidVpcPeeringConnectionIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeVolumesRequest> volumeAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVolumesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VolumeAvailable.IsAvailableMatcher(), new VolumeAvailable.IsDeletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstanceStatusRequest> instanceStatusOk() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstanceStatusFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceStatusOk.IsOkMatcher(), new InstanceStatusOk.IsInvalidInstanceIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeVolumesRequest> volumeDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVolumesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VolumeDeleted.IsDeletedMatcher(), new VolumeDeleted.IsInvalidVolumeNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeCustomerGatewaysRequest> customerGatewayAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeCustomerGatewaysFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new CustomerGatewayAvailable.IsAvailableMatcher(), new CustomerGatewayAvailable.IsDeletedMatcher(), new CustomerGatewayAvailable.IsDeletingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNatGatewaysRequest> natGatewayAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNatGatewaysFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NatGatewayAvailable.IsAvailableMatcher(), new NatGatewayAvailable.IsFailedMatcher(), new NatGatewayAvailable.IsDeletingMatcher(), new NatGatewayAvailable.IsDeletedMatcher(), new NatGatewayAvailable.IsNatGatewayNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeVpcsRequest> vpcExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVpcsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new VpcExists.IsInvalidVpcIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(5), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeConversionTasksRequest> conversionTaskDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeConversionTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ConversionTaskDeleted.IsDeletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeImagesRequest> imageExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeImagesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ImageExists.IsTrueMatcher(), new ImageExists.IsInvalidAMIIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeVpcsRequest> vpcAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVpcsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VpcAvailable.IsAvailableMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeVpcPeeringConnectionsRequest> vpcPeeringConnectionDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVpcPeeringConnectionsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VpcPeeringConnectionDeleted.IsDeletedMatcher(), new VpcPeeringConnectionDeleted.IsInvalidVpcPeeringConnectionIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeConversionTasksRequest> conversionTaskCancelled() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeConversionTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ConversionTaskCancelled.IsCancelledMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstancesRequest> instanceExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceExists.IsTrueMatcher(), new InstanceExists.IsInvalidInstanceIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstancesRequest> instanceTerminated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceTerminated.IsTerminatedMatcher(), new InstanceTerminated.IsPendingMatcher(), new InstanceTerminated.IsStoppingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeConversionTasksRequest> conversionTaskCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeConversionTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ConversionTaskCompleted.IsCompletedMatcher(), new ConversionTaskCompleted.IsCancelledMatcher(), new ConversionTaskCompleted.IsCancellingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeKeyPairsRequest> keyPairExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeKeyPairsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new KeyPairExists.IsTrueMatcher(), new KeyPairExists.IsInvalidKeyPairNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(6), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeSpotInstanceRequestsRequest> spotInstanceRequestFulfilled() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeSpotInstanceRequestsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new SpotInstanceRequestFulfilled.IsFulfilledMatcher(), new SpotInstanceRequestFulfilled.IsScheduleexpiredMatcher(), new SpotInstanceRequestFulfilled.IsCanceledbeforefulfillmentMatcher(), new SpotInstanceRequestFulfilled.IsBadparametersMatcher(), new SpotInstanceRequestFulfilled.IsSystemerrorMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeBundleTasksRequest> bundleTaskComplete() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeBundleTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new BundleTaskComplete.IsCompleteMatcher(), new BundleTaskComplete.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstancesRequest> instanceRunning() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceRunning.IsRunningMatcher(), new InstanceRunning.IsShuttingdownMatcher(), new InstanceRunning.IsTerminatedMatcher(), new InstanceRunning.IsStoppingMatcher(), new InstanceRunning.IsInvalidInstanceIDNotFoundMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeExportTasksRequest> exportTaskCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeExportTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ExportTaskCompleted.IsCompletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeSnapshotsRequest> snapshotCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeSnapshotsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new SnapshotCompleted.IsCompletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeExportTasksRequest> exportTaskCancelled() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeExportTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ExportTaskCancelled.IsCancelledMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeVpnConnectionsRequest> vpnConnectionDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVpnConnectionsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VpnConnectionDeleted.IsDeletedMatcher(), new VpnConnectionDeleted.IsPendingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeVpnConnectionsRequest> vpnConnectionAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeVpnConnectionsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new VpnConnectionAvailable.IsAvailableMatcher(), new VpnConnectionAvailable.IsDeletingMatcher(), new VpnConnectionAvailable.IsDeletedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstancesRequest> instanceStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new InstanceStopped.IsStoppedMatcher(), new InstanceStopped.IsPendingMatcher(), new InstanceStopped.IsTerminatedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeSubnetsRequest> subnetAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeSubnetsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new SubnetAvailable.IsAvailableMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }
}

