/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.util;

import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;

@ReviewBeforeRelease(value="Public API? Should it be cleaned up?")
public class SecurityGroupUtils {
    private static final String INVALID_GROUP_NOT_FOUND = "InvalidGroup.NotFound";

    public static boolean doesSecurityGroupExist(EC2Client ec2, String securityGroupName) throws AmazonClientException {
        DescribeSecurityGroupsRequest securityGroupsRequest = (DescribeSecurityGroupsRequest)((Object)DescribeSecurityGroupsRequest.builder().groupNames(securityGroupName).build());
        try {
            ec2.describeSecurityGroups(securityGroupsRequest);
            return true;
        }
        catch (AmazonServiceException ase) {
            if (INVALID_GROUP_NOT_FOUND.equals(ase.getErrorCode())) {
                return false;
            }
            throw ase;
        }
    }
}

