/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import software.amazon.awssdk.SdkRequest;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.interceptor.Context;
import software.amazon.awssdk.interceptor.ExecutionAttributes;
import software.amazon.awssdk.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest;

public final class TimestampFormatInterceptor
implements ExecutionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("\\.\\d\\d\\dZ");
    private static final String START_TIME = "StartTime";
    private static final String VALID_FROM = "SpotFleetRequestConfig.ValidFrom";
    private static final String VALID_UNTIL = "SpotFleetRequestConfig.ValidUntil";

    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest original = context.request();
        if (original instanceof DescribeSpotFleetRequestHistoryRequest) {
            Map params = request.getParameters();
            List startTime = (List)params.get(START_TIME);
            if (startTime != null && !startTime.isEmpty()) {
                return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).queryParameter(START_TIME, Collections.singletonList(this.sanitize((String)startTime.get(0)))).build();
            }
        } else if (original instanceof RequestSpotFleetRequest) {
            Map params = request.getParameters();
            List validFrom = (List)params.get(VALID_FROM);
            List validUntil = (List)params.get(VALID_UNTIL);
            return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)((SdkHttpFullRequest.Builder)request.toBuilder()).apply(builder -> {
                if (validFrom != null && !validFrom.isEmpty()) {
                    builder.queryParameter(VALID_FROM, Collections.singletonList(this.sanitize((String)validFrom.get(0))));
                }
                if (validUntil != null && !validUntil.isEmpty()) {
                    builder.queryParameter(VALID_UNTIL, Collections.singletonList(this.sanitize((String)validUntil.get(0))));
                }
                return builder;
            })).build();
        }
        return request;
    }

    private String sanitize(String input) {
        return PATTERN.matcher(input).replaceFirst("Z");
    }
}

