/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest;
import software.amazon.awssdk.util.StringUtils;

public class ReplaceRouteRequestMarshaller
implements Marshaller<Request<ReplaceRouteRequest>, ReplaceRouteRequest> {
    public Request<ReplaceRouteRequest> marshall(ReplaceRouteRequest replaceRouteRequest) {
        if (replaceRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceRouteRequest, "EC2Client");
        request.addParameter("Action", "ReplaceRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceRouteRequest.destinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString((String)replaceRouteRequest.destinationCidrBlock()));
        }
        if (replaceRouteRequest.destinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock", StringUtils.fromString((String)replaceRouteRequest.destinationIpv6CidrBlock()));
        }
        if (replaceRouteRequest.egressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId", StringUtils.fromString((String)replaceRouteRequest.egressOnlyInternetGatewayId()));
        }
        if (replaceRouteRequest.gatewayId() != null) {
            request.addParameter("GatewayId", StringUtils.fromString((String)replaceRouteRequest.gatewayId()));
        }
        if (replaceRouteRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)replaceRouteRequest.instanceId()));
        }
        if (replaceRouteRequest.natGatewayId() != null) {
            request.addParameter("NatGatewayId", StringUtils.fromString((String)replaceRouteRequest.natGatewayId()));
        }
        if (replaceRouteRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)replaceRouteRequest.networkInterfaceId()));
        }
        if (replaceRouteRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString((String)replaceRouteRequest.routeTableId()));
        }
        if (replaceRouteRequest.vpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringUtils.fromString((String)replaceRouteRequest.vpcPeeringConnectionId()));
        }
        return request;
    }
}

