/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.transform.EbsInstanceBlockDeviceUnmarshaller;

public class InstanceBlockDeviceMappingUnmarshaller
implements Unmarshaller<InstanceBlockDeviceMapping, StaxUnmarshallerContext> {
    private static final InstanceBlockDeviceMappingUnmarshaller INSTANCE = new InstanceBlockDeviceMappingUnmarshaller();

    public InstanceBlockDeviceMapping unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        InstanceBlockDeviceMapping.Builder instanceBlockDeviceMapping = InstanceBlockDeviceMapping.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("deviceName", targetDepth)) {
                    instanceBlockDeviceMapping.deviceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ebs", targetDepth)) continue;
                instanceBlockDeviceMapping.ebs(EbsInstanceBlockDeviceUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (InstanceBlockDeviceMapping)instanceBlockDeviceMapping.build();
    }

    public static InstanceBlockDeviceMappingUnmarshaller getInstance() {
        return INSTANCE;
    }
}

