/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ClientData;
import software.amazon.awssdk.services.ec2.model.ImportSnapshotRequest;
import software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer;
import software.amazon.awssdk.services.ec2.model.UserBucket;
import software.amazon.awssdk.util.StringUtils;

public class ImportSnapshotRequestMarshaller
implements Marshaller<Request<ImportSnapshotRequest>, ImportSnapshotRequest> {
    public Request<ImportSnapshotRequest> marshall(ImportSnapshotRequest importSnapshotRequest) {
        SnapshotDiskContainer diskContainer;
        if (importSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importSnapshotRequest, "EC2Client");
        request.addParameter("Action", "ImportSnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        ClientData clientData = importSnapshotRequest.clientData();
        if (clientData != null) {
            if (clientData.comment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString((String)clientData.comment()));
            }
            if (clientData.uploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromInstant((Instant)clientData.uploadEnd()));
            }
            if (clientData.uploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble((Double)clientData.uploadSize()));
            }
            if (clientData.uploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromInstant((Instant)clientData.uploadStart()));
            }
        }
        if (importSnapshotRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)importSnapshotRequest.clientToken()));
        }
        if (importSnapshotRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importSnapshotRequest.description()));
        }
        if ((diskContainer = importSnapshotRequest.diskContainer()) != null) {
            UserBucket userBucket;
            if (diskContainer.description() != null) {
                request.addParameter("DiskContainer.Description", StringUtils.fromString((String)diskContainer.description()));
            }
            if (diskContainer.format() != null) {
                request.addParameter("DiskContainer.Format", StringUtils.fromString((String)diskContainer.format()));
            }
            if (diskContainer.url() != null) {
                request.addParameter("DiskContainer.Url", StringUtils.fromString((String)diskContainer.url()));
            }
            if ((userBucket = diskContainer.userBucket()) != null) {
                if (userBucket.s3Bucket() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Bucket", StringUtils.fromString((String)userBucket.s3Bucket()));
                }
                if (userBucket.s3Key() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Key", StringUtils.fromString((String)userBucket.s3Key()));
                }
            }
        }
        if (importSnapshotRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)importSnapshotRequest.roleName()));
        }
        return request;
    }
}

