/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeVpnGatewaysRequestMarshaller
implements Marshaller<Request<DescribeVpnGatewaysRequest>, DescribeVpnGatewaysRequest> {
    public Request<DescribeVpnGatewaysRequest> marshall(DescribeVpnGatewaysRequest describeVpnGatewaysRequest) {
        List<String> describeVpnGatewaysRequestVpnGatewayIdsList;
        if (describeVpnGatewaysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpnGatewaysRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpnGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeVpnGatewaysRequestFiltersList = describeVpnGatewaysRequest.filters();
        if (describeVpnGatewaysRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeVpnGatewaysRequestFiltersListValue : describeVpnGatewaysRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpnGatewaysRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpnGatewaysRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeVpnGatewaysRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeVpnGatewaysRequestVpnGatewayIdsList = describeVpnGatewaysRequest.vpnGatewayIds()) != null) {
            int vpnGatewayIdsListIndex = 1;
            for (String describeVpnGatewaysRequestVpnGatewayIdsListValue : describeVpnGatewaysRequestVpnGatewayIdsList) {
                if (describeVpnGatewaysRequestVpnGatewayIdsListValue != null) {
                    request.addParameter("VpnGatewayId." + vpnGatewayIdsListIndex, StringUtils.fromString((String)describeVpnGatewaysRequestVpnGatewayIdsListValue));
                }
                ++vpnGatewayIdsListIndex;
            }
        }
        return request;
    }
}

