/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeVpcAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeVpcAttributeRequestMarshaller
implements Marshaller<Request<DescribeVpcAttributeRequest>, DescribeVpcAttributeRequest> {
    public Request<DescribeVpcAttributeRequest> marshall(DescribeVpcAttributeRequest describeVpcAttributeRequest) {
        if (describeVpcAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpcAttributeRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeVpcAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)describeVpcAttributeRequest.attribute()));
        }
        if (describeVpcAttributeRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)describeVpcAttributeRequest.vpcId()));
        }
        return request;
    }
}

