/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeHostsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeHostsRequestMarshaller
implements Marshaller<Request<DescribeHostsRequest>, DescribeHostsRequest> {
    public Request<DescribeHostsRequest> marshall(DescribeHostsRequest describeHostsRequest) {
        List<String> describeHostsRequestHostIdsList;
        if (describeHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeHostsRequest, "EC2Client");
        request.addParameter("Action", "DescribeHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeHostsRequestFilterList = describeHostsRequest.filter();
        if (describeHostsRequestFilterList != null) {
            int filterListIndex = 1;
            for (Filter describeHostsRequestFilterListValue : describeHostsRequestFilterList) {
                List<String> filterValuesList;
                if (describeHostsRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)describeHostsRequestFilterListValue.name()));
                }
                if ((filterValuesList = describeHostsRequestFilterListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if ((describeHostsRequestHostIdsList = describeHostsRequest.hostIds()) != null) {
            int hostIdsListIndex = 1;
            for (String describeHostsRequestHostIdsListValue : describeHostsRequestHostIdsList) {
                if (describeHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString((String)describeHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        if (describeHostsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeHostsRequest.maxResults()));
        }
        if (describeHostsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeHostsRequest.nextToken()));
        }
        return request;
    }
}

