/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRouteRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateVpnConnectionRouteRequestMarshaller
implements Marshaller<Request<CreateVpnConnectionRouteRequest>, CreateVpnConnectionRouteRequest> {
    public Request<CreateVpnConnectionRouteRequest> marshall(CreateVpnConnectionRouteRequest createVpnConnectionRouteRequest) {
        if (createVpnConnectionRouteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVpnConnectionRouteRequest, "EC2Client");
        request.addParameter("Action", "CreateVpnConnectionRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpnConnectionRouteRequest.destinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString((String)createVpnConnectionRouteRequest.destinationCidrBlock()));
        }
        if (createVpnConnectionRouteRequest.vpnConnectionId() != null) {
            request.addParameter("VpnConnectionId", StringUtils.fromString((String)createVpnConnectionRouteRequest.vpnConnectionId()));
        }
        return request;
    }
}

