/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateVpcRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateVpcRequestMarshaller
implements Marshaller<Request<CreateVpcRequest>, CreateVpcRequest> {
    public Request<CreateVpcRequest> marshall(CreateVpcRequest createVpcRequest) {
        if (createVpcRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVpcRequest, "EC2Client");
        request.addParameter("Action", "CreateVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcRequest.cidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)createVpcRequest.cidrBlock()));
        }
        if (createVpcRequest.amazonProvidedIpv6CidrBlock() != null) {
            request.addParameter("AmazonProvidedIpv6CidrBlock", StringUtils.fromBoolean((Boolean)createVpcRequest.amazonProvidedIpv6CidrBlock()));
        }
        if (createVpcRequest.instanceTenancy() != null) {
            request.addParameter("InstanceTenancy", StringUtils.fromString((String)createVpcRequest.instanceTenancy()));
        }
        return request;
    }
}

