/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateReservedInstancesListingRequest;
import software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification;
import software.amazon.awssdk.util.StringUtils;

public class CreateReservedInstancesListingRequestMarshaller
implements Marshaller<Request<CreateReservedInstancesListingRequest>, CreateReservedInstancesListingRequest> {
    public Request<CreateReservedInstancesListingRequest> marshall(CreateReservedInstancesListingRequest createReservedInstancesListingRequest) {
        List<PriceScheduleSpecification> createReservedInstancesListingRequestPriceSchedulesList;
        if (createReservedInstancesListingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReservedInstancesListingRequest, "EC2Client");
        request.addParameter("Action", "CreateReservedInstancesListing");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReservedInstancesListingRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createReservedInstancesListingRequest.clientToken()));
        }
        if (createReservedInstancesListingRequest.instanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)createReservedInstancesListingRequest.instanceCount()));
        }
        if ((createReservedInstancesListingRequestPriceSchedulesList = createReservedInstancesListingRequest.priceSchedules()) != null) {
            int priceSchedulesListIndex = 1;
            for (PriceScheduleSpecification createReservedInstancesListingRequestPriceSchedulesListValue : createReservedInstancesListingRequestPriceSchedulesList) {
                if (createReservedInstancesListingRequestPriceSchedulesListValue.currencyCode() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".CurrencyCode", StringUtils.fromString((String)createReservedInstancesListingRequestPriceSchedulesListValue.currencyCode()));
                }
                if (createReservedInstancesListingRequestPriceSchedulesListValue.price() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Price", StringUtils.fromDouble((Double)createReservedInstancesListingRequestPriceSchedulesListValue.price()));
                }
                if (createReservedInstancesListingRequestPriceSchedulesListValue.term() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Term", StringUtils.fromLong((Long)createReservedInstancesListingRequestPriceSchedulesListValue.term()));
                }
                ++priceSchedulesListIndex;
            }
        }
        if (createReservedInstancesListingRequest.reservedInstancesId() != null) {
            request.addParameter("ReservedInstancesId", StringUtils.fromString((String)createReservedInstancesListingRequest.reservedInstancesId()));
        }
        return request;
    }
}

