/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociationSetCopier;
import software.amazon.awssdk.services.ec2.model.VpcState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Vpc
implements ToCopyableBuilder<Builder, Vpc> {
    private final String cidrBlock;
    private final String dhcpOptionsId;
    private final String state;
    private final String vpcId;
    private final String instanceTenancy;
    private final List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;
    private final Boolean isDefault;
    private final List<Tag> tags;

    private Vpc(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.state = builder.state;
        this.vpcId = builder.vpcId;
        this.instanceTenancy = builder.instanceTenancy;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.isDefault = builder.isDefault;
        this.tags = builder.tags;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public String dhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public String state() {
        return this.state;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String instanceTenancy() {
        return this.instanceTenancy;
    }

    public List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return this.ipv6CidrBlockAssociationSet;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cidrBlock() == null ? 0 : this.cidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.dhcpOptionsId() == null ? 0 : this.dhcpOptionsId().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.instanceTenancy() == null ? 0 : this.instanceTenancy().hashCode());
        hashCode = 31 * hashCode + (this.ipv6CidrBlockAssociationSet() == null ? 0 : this.ipv6CidrBlockAssociationSet().hashCode());
        hashCode = 31 * hashCode + (this.isDefault() == null ? 0 : this.isDefault().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vpc)) {
            return false;
        }
        Vpc other = (Vpc)obj;
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.dhcpOptionsId() == null ^ this.dhcpOptionsId() == null) {
            return false;
        }
        if (other.dhcpOptionsId() != null && !other.dhcpOptionsId().equals(this.dhcpOptionsId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.instanceTenancy() == null ^ this.instanceTenancy() == null) {
            return false;
        }
        if (other.instanceTenancy() != null && !other.instanceTenancy().equals(this.instanceTenancy())) {
            return false;
        }
        if (other.ipv6CidrBlockAssociationSet() == null ^ this.ipv6CidrBlockAssociationSet() == null) {
            return false;
        }
        if (other.ipv6CidrBlockAssociationSet() != null && !other.ipv6CidrBlockAssociationSet().equals(this.ipv6CidrBlockAssociationSet())) {
            return false;
        }
        if (other.isDefault() == null ^ this.isDefault() == null) {
            return false;
        }
        if (other.isDefault() != null && !other.isDefault().equals(this.isDefault())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.cidrBlock()).append(",");
        }
        if (this.dhcpOptionsId() != null) {
            sb.append("DhcpOptionsId: ").append(this.dhcpOptionsId()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.instanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(this.instanceTenancy()).append(",");
        }
        if (this.ipv6CidrBlockAssociationSet() != null) {
            sb.append("Ipv6CidrBlockAssociationSet: ").append(this.ipv6CidrBlockAssociationSet()).append(",");
        }
        if (this.isDefault() != null) {
            sb.append("IsDefault: ").append(this.isDefault()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String cidrBlock;
        private String dhcpOptionsId;
        private String state;
        private String vpcId;
        private String instanceTenancy;
        private List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;
        private Boolean isDefault;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Vpc model) {
            this.setCidrBlock(model.cidrBlock);
            this.setDhcpOptionsId(model.dhcpOptionsId);
            this.setState(model.state);
            this.setVpcId(model.vpcId);
            this.setInstanceTenancy(model.instanceTenancy);
            this.setIpv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            this.setIsDefault(model.isDefault);
            this.setTags(model.tags);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final String getDhcpOptionsId() {
            return this.dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final Collection<VpcIpv6CidrBlockAssociation> getIpv6CidrBlockAssociationSet() {
            return this.ipv6CidrBlockAssociationSet;
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        public final void setIpv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public Vpc build() {
            return new Vpc(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Vpc> {
        public Builder cidrBlock(String var1);

        public Builder dhcpOptionsId(String var1);

        public Builder state(String var1);

        public Builder state(VpcState var1);

        public Builder vpcId(String var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> var1);

        public Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation ... var1);

        public Builder isDefault(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

