/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RunScheduledInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RunScheduledInstancesRequest> {
    private final String clientToken;
    private final Integer instanceCount;
    private final ScheduledInstancesLaunchSpecification launchSpecification;
    private final String scheduledInstanceId;

    private RunScheduledInstancesRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.launchSpecification = builder.launchSpecification;
        this.scheduledInstanceId = builder.scheduledInstanceId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public ScheduledInstancesLaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public String scheduledInstanceId() {
        return this.scheduledInstanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.launchSpecification() == null ? 0 : this.launchSpecification().hashCode());
        hashCode = 31 * hashCode + (this.scheduledInstanceId() == null ? 0 : this.scheduledInstanceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunScheduledInstancesRequest)) {
            return false;
        }
        RunScheduledInstancesRequest other = (RunScheduledInstancesRequest)((Object)obj);
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.launchSpecification() == null ^ this.launchSpecification() == null) {
            return false;
        }
        if (other.launchSpecification() != null && !other.launchSpecification().equals(this.launchSpecification())) {
            return false;
        }
        if (other.scheduledInstanceId() == null ^ this.scheduledInstanceId() == null) {
            return false;
        }
        return other.scheduledInstanceId() == null || other.scheduledInstanceId().equals(this.scheduledInstanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.launchSpecification() != null) {
            sb.append("LaunchSpecification: ").append(this.launchSpecification()).append(",");
        }
        if (this.scheduledInstanceId() != null) {
            sb.append("ScheduledInstanceId: ").append(this.scheduledInstanceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private Integer instanceCount;
        private ScheduledInstancesLaunchSpecification launchSpecification;
        private String scheduledInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(RunScheduledInstancesRequest model) {
            this.setClientToken(model.clientToken);
            this.setInstanceCount(model.instanceCount);
            this.setLaunchSpecification(model.launchSpecification);
            this.setScheduledInstanceId(model.scheduledInstanceId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final ScheduledInstancesLaunchSpecification getLaunchSpecification() {
            return this.launchSpecification;
        }

        @Override
        public final Builder launchSpecification(ScheduledInstancesLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(ScheduledInstancesLaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
        }

        public final String getScheduledInstanceId() {
            return this.scheduledInstanceId;
        }

        @Override
        public final Builder scheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
            return this;
        }

        public final void setScheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
        }

        public RunScheduledInstancesRequest build() {
            return new RunScheduledInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RunScheduledInstancesRequest> {
        public Builder clientToken(String var1);

        public Builder instanceCount(Integer var1);

        public Builder launchSpecification(ScheduledInstancesLaunchSpecification var1);

        public Builder scheduledInstanceId(String var1);
    }
}

