/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.PricingDetail;
import software.amazon.awssdk.services.ec2.model.PricingDetailsListCopier;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.RecurringCharge;
import software.amazon.awssdk.services.ec2.model.RecurringChargesListCopier;
import software.amazon.awssdk.services.ec2.model.Scope;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstancesOffering
implements ToCopyableBuilder<Builder, ReservedInstancesOffering> {
    private final String availabilityZone;
    private final Long duration;
    private final Float fixedPrice;
    private final String instanceType;
    private final String productDescription;
    private final String reservedInstancesOfferingId;
    private final Float usagePrice;
    private final String currencyCode;
    private final String instanceTenancy;
    private final Boolean marketplace;
    private final String offeringClass;
    private final String offeringType;
    private final List<PricingDetail> pricingDetails;
    private final List<RecurringCharge> recurringCharges;
    private final String scope;

    private ReservedInstancesOffering(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.reservedInstancesOfferingId = builder.reservedInstancesOfferingId;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.marketplace = builder.marketplace;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.pricingDetails = builder.pricingDetails;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Long duration() {
        return this.duration;
    }

    public Float fixedPrice() {
        return this.fixedPrice;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public String reservedInstancesOfferingId() {
        return this.reservedInstancesOfferingId;
    }

    public Float usagePrice() {
        return this.usagePrice;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public String instanceTenancy() {
        return this.instanceTenancy;
    }

    public Boolean marketplace() {
        return this.marketplace;
    }

    public String offeringClass() {
        return this.offeringClass;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public List<PricingDetail> pricingDetails() {
        return this.pricingDetails;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public String scope() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.fixedPrice() == null ? 0 : this.fixedPrice().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.productDescription() == null ? 0 : this.productDescription().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesOfferingId() == null ? 0 : this.reservedInstancesOfferingId().hashCode());
        hashCode = 31 * hashCode + (this.usagePrice() == null ? 0 : this.usagePrice().hashCode());
        hashCode = 31 * hashCode + (this.currencyCode() == null ? 0 : this.currencyCode().hashCode());
        hashCode = 31 * hashCode + (this.instanceTenancy() == null ? 0 : this.instanceTenancy().hashCode());
        hashCode = 31 * hashCode + (this.marketplace() == null ? 0 : this.marketplace().hashCode());
        hashCode = 31 * hashCode + (this.offeringClass() == null ? 0 : this.offeringClass().hashCode());
        hashCode = 31 * hashCode + (this.offeringType() == null ? 0 : this.offeringType().hashCode());
        hashCode = 31 * hashCode + (this.pricingDetails() == null ? 0 : this.pricingDetails().hashCode());
        hashCode = 31 * hashCode + (this.recurringCharges() == null ? 0 : this.recurringCharges().hashCode());
        hashCode = 31 * hashCode + (this.scope() == null ? 0 : this.scope().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesOffering)) {
            return false;
        }
        ReservedInstancesOffering other = (ReservedInstancesOffering)obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.fixedPrice() == null ^ this.fixedPrice() == null) {
            return false;
        }
        if (other.fixedPrice() != null && !other.fixedPrice().equals(this.fixedPrice())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.productDescription() == null ^ this.productDescription() == null) {
            return false;
        }
        if (other.productDescription() != null && !other.productDescription().equals(this.productDescription())) {
            return false;
        }
        if (other.reservedInstancesOfferingId() == null ^ this.reservedInstancesOfferingId() == null) {
            return false;
        }
        if (other.reservedInstancesOfferingId() != null && !other.reservedInstancesOfferingId().equals(this.reservedInstancesOfferingId())) {
            return false;
        }
        if (other.usagePrice() == null ^ this.usagePrice() == null) {
            return false;
        }
        if (other.usagePrice() != null && !other.usagePrice().equals(this.usagePrice())) {
            return false;
        }
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.instanceTenancy() == null ^ this.instanceTenancy() == null) {
            return false;
        }
        if (other.instanceTenancy() != null && !other.instanceTenancy().equals(this.instanceTenancy())) {
            return false;
        }
        if (other.marketplace() == null ^ this.marketplace() == null) {
            return false;
        }
        if (other.marketplace() != null && !other.marketplace().equals(this.marketplace())) {
            return false;
        }
        if (other.offeringClass() == null ^ this.offeringClass() == null) {
            return false;
        }
        if (other.offeringClass() != null && !other.offeringClass().equals(this.offeringClass())) {
            return false;
        }
        if (other.offeringType() == null ^ this.offeringType() == null) {
            return false;
        }
        if (other.offeringType() != null && !other.offeringType().equals(this.offeringType())) {
            return false;
        }
        if (other.pricingDetails() == null ^ this.pricingDetails() == null) {
            return false;
        }
        if (other.pricingDetails() != null && !other.pricingDetails().equals(this.pricingDetails())) {
            return false;
        }
        if (other.recurringCharges() == null ^ this.recurringCharges() == null) {
            return false;
        }
        if (other.recurringCharges() != null && !other.recurringCharges().equals(this.recurringCharges())) {
            return false;
        }
        if (other.scope() == null ^ this.scope() == null) {
            return false;
        }
        return other.scope() == null || other.scope().equals(this.scope());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.fixedPrice() != null) {
            sb.append("FixedPrice: ").append(this.fixedPrice()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.productDescription() != null) {
            sb.append("ProductDescription: ").append(this.productDescription()).append(",");
        }
        if (this.reservedInstancesOfferingId() != null) {
            sb.append("ReservedInstancesOfferingId: ").append(this.reservedInstancesOfferingId()).append(",");
        }
        if (this.usagePrice() != null) {
            sb.append("UsagePrice: ").append(this.usagePrice()).append(",");
        }
        if (this.currencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCode()).append(",");
        }
        if (this.instanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(this.instanceTenancy()).append(",");
        }
        if (this.marketplace() != null) {
            sb.append("Marketplace: ").append(this.marketplace()).append(",");
        }
        if (this.offeringClass() != null) {
            sb.append("OfferingClass: ").append(this.offeringClass()).append(",");
        }
        if (this.offeringType() != null) {
            sb.append("OfferingType: ").append(this.offeringType()).append(",");
        }
        if (this.pricingDetails() != null) {
            sb.append("PricingDetails: ").append(this.pricingDetails()).append(",");
        }
        if (this.recurringCharges() != null) {
            sb.append("RecurringCharges: ").append(this.recurringCharges()).append(",");
        }
        if (this.scope() != null) {
            sb.append("Scope: ").append(this.scope()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Long duration;
        private Float fixedPrice;
        private String instanceType;
        private String productDescription;
        private String reservedInstancesOfferingId;
        private Float usagePrice;
        private String currencyCode;
        private String instanceTenancy;
        private Boolean marketplace;
        private String offeringClass;
        private String offeringType;
        private List<PricingDetail> pricingDetails;
        private List<RecurringCharge> recurringCharges;
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesOffering model) {
            this.setAvailabilityZone(model.availabilityZone);
            this.setDuration(model.duration);
            this.setFixedPrice(model.fixedPrice);
            this.setInstanceType(model.instanceType);
            this.setProductDescription(model.productDescription);
            this.setReservedInstancesOfferingId(model.reservedInstancesOfferingId);
            this.setUsagePrice(model.usagePrice);
            this.setCurrencyCode(model.currencyCode);
            this.setInstanceTenancy(model.instanceTenancy);
            this.setMarketplace(model.marketplace);
            this.setOfferingClass(model.offeringClass);
            this.setOfferingType(model.offeringType);
            this.setPricingDetails(model.pricingDetails);
            this.setRecurringCharges(model.recurringCharges);
            this.setScope(model.scope);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Float getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getReservedInstancesOfferingId() {
            return this.reservedInstancesOfferingId;
        }

        @Override
        public final Builder reservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
            return this;
        }

        public final void setReservedInstancesOfferingId(String reservedInstancesOfferingId) {
            this.reservedInstancesOfferingId = reservedInstancesOfferingId;
        }

        public final Float getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final Boolean getMarketplace() {
            return this.marketplace;
        }

        @Override
        public final Builder marketplace(Boolean marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public final void setMarketplace(Boolean marketplace) {
            this.marketplace = marketplace;
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Collection<PricingDetail> getPricingDetails() {
            return this.pricingDetails;
        }

        @Override
        public final Builder pricingDetails(Collection<PricingDetail> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copy(pricingDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingDetails(PricingDetail ... pricingDetails) {
            this.pricingDetails(Arrays.asList(pricingDetails));
            return this;
        }

        public final void setPricingDetails(Collection<PricingDetail> pricingDetails) {
            this.pricingDetails = PricingDetailsListCopier.copy(pricingDetails);
        }

        public final Collection<RecurringCharge> getRecurringCharges() {
            return this.recurringCharges;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
        }

        public final String getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public ReservedInstancesOffering build() {
            return new ReservedInstancesOffering(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstancesOffering> {
        public Builder availabilityZone(String var1);

        public Builder duration(Long var1);

        public Builder fixedPrice(Float var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder reservedInstancesOfferingId(String var1);

        public Builder usagePrice(Float var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder marketplace(Boolean var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);

        public Builder pricingDetails(Collection<PricingDetail> var1);

        public Builder pricingDetails(PricingDetail ... var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);
    }
}

