/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.GroupNameStringListCopier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LaunchSpecification
implements ToCopyableBuilder<Builder, LaunchSpecification> {
    private final String userData;
    private final String addressingType;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final Boolean ebsOptimized;
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String imageId;
    private final String instanceType;
    private final String kernelId;
    private final String keyName;
    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private final SpotPlacement placement;
    private final String ramdiskId;
    private final String subnetId;
    private final List<GroupIdentifier> allSecurityGroups;
    private final Boolean monitoringEnabled;
    private final List<String> securityGroups;

    private LaunchSpecification(BuilderImpl builder) {
        this.userData = builder.userData;
        this.addressingType = builder.addressingType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.networkInterfaces = builder.networkInterfaces;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.subnetId = builder.subnetId;
        this.allSecurityGroups = builder.allSecurityGroups;
        this.monitoringEnabled = builder.monitoringEnabled;
        this.securityGroups = builder.securityGroups;
    }

    public String userData() {
        return this.userData;
    }

    public String addressingType() {
        return this.addressingType;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String imageId() {
        return this.imageId;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String keyName() {
        return this.keyName;
    }

    public List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public SpotPlacement placement() {
        return this.placement;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public List<GroupIdentifier> allSecurityGroups() {
        return this.allSecurityGroups;
    }

    public Boolean monitoringEnabled() {
        return this.monitoringEnabled;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.userData() == null ? 0 : this.userData().hashCode());
        hashCode = 31 * hashCode + (this.addressingType() == null ? 0 : this.addressingType().hashCode());
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.iamInstanceProfile() == null ? 0 : this.iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.kernelId() == null ? 0 : this.kernelId().hashCode());
        hashCode = 31 * hashCode + (this.keyName() == null ? 0 : this.keyName().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaces() == null ? 0 : this.networkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.placement() == null ? 0 : this.placement().hashCode());
        hashCode = 31 * hashCode + (this.ramdiskId() == null ? 0 : this.ramdiskId().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.allSecurityGroups() == null ? 0 : this.allSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.monitoringEnabled() == null ? 0 : this.monitoringEnabled().hashCode());
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchSpecification)) {
            return false;
        }
        LaunchSpecification other = (LaunchSpecification)obj;
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.addressingType() == null ^ this.addressingType() == null) {
            return false;
        }
        if (other.addressingType() != null && !other.addressingType().equals(this.addressingType())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.networkInterfaces() == null ^ this.networkInterfaces() == null) {
            return false;
        }
        if (other.networkInterfaces() != null && !other.networkInterfaces().equals(this.networkInterfaces())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.allSecurityGroups() == null ^ this.allSecurityGroups() == null) {
            return false;
        }
        if (other.allSecurityGroups() != null && !other.allSecurityGroups().equals(this.allSecurityGroups())) {
            return false;
        }
        if (other.monitoringEnabled() == null ^ this.monitoringEnabled() == null) {
            return false;
        }
        if (other.monitoringEnabled() != null && !other.monitoringEnabled().equals(this.monitoringEnabled())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        return other.securityGroups() == null || other.securityGroups().equals(this.securityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        if (this.addressingType() != null) {
            sb.append("AddressingType: ").append(this.addressingType()).append(",");
        }
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.iamInstanceProfile()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.kernelId() != null) {
            sb.append("KernelId: ").append(this.kernelId()).append(",");
        }
        if (this.keyName() != null) {
            sb.append("KeyName: ").append(this.keyName()).append(",");
        }
        if (this.networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.networkInterfaces()).append(",");
        }
        if (this.placement() != null) {
            sb.append("Placement: ").append(this.placement()).append(",");
        }
        if (this.ramdiskId() != null) {
            sb.append("RamdiskId: ").append(this.ramdiskId()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.allSecurityGroups() != null) {
            sb.append("AllSecurityGroups: ").append(this.allSecurityGroups()).append(",");
        }
        if (this.monitoringEnabled() != null) {
            sb.append("MonitoringEnabled: ").append(this.monitoringEnabled()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String userData;
        private String addressingType;
        private List<BlockDeviceMapping> blockDeviceMappings;
        private Boolean ebsOptimized;
        private IamInstanceProfileSpecification iamInstanceProfile;
        private String imageId;
        private String instanceType;
        private String kernelId;
        private String keyName;
        private List<InstanceNetworkInterfaceSpecification> networkInterfaces;
        private SpotPlacement placement;
        private String ramdiskId;
        private String subnetId;
        private List<GroupIdentifier> allSecurityGroups;
        private Boolean monitoringEnabled;
        private List<String> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchSpecification model) {
            this.setUserData(model.userData);
            this.setAddressingType(model.addressingType);
            this.setBlockDeviceMappings(model.blockDeviceMappings);
            this.setEbsOptimized(model.ebsOptimized);
            this.setIamInstanceProfile(model.iamInstanceProfile);
            this.setImageId(model.imageId);
            this.setInstanceType(model.instanceType);
            this.setKernelId(model.kernelId);
            this.setKeyName(model.keyName);
            this.setNetworkInterfaces(model.networkInterfaces);
            this.setPlacement(model.placement);
            this.setRamdiskId(model.ramdiskId);
            this.setSubnetId(model.subnetId);
            this.setAllSecurityGroups(model.allSecurityGroups);
            this.setMonitoringEnabled(model.monitoringEnabled);
            this.setSecurityGroups(model.securityGroups);
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getAddressingType() {
            return this.addressingType;
        }

        @Override
        public final Builder addressingType(String addressingType) {
            this.addressingType = addressingType;
            return this;
        }

        public final void setAddressingType(String addressingType) {
            this.addressingType = addressingType;
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final IamInstanceProfileSpecification getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Collection<InstanceNetworkInterfaceSpecification> getNetworkInterfaces() {
            return this.networkInterfaces;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
        }

        public final SpotPlacement getPlacement() {
            return this.placement;
        }

        @Override
        public final Builder placement(SpotPlacement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(SpotPlacement placement) {
            this.placement = placement;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<GroupIdentifier> getAllSecurityGroups() {
            return this.allSecurityGroups;
        }

        @Override
        public final Builder allSecurityGroups(Collection<GroupIdentifier> allSecurityGroups) {
            this.allSecurityGroups = GroupIdentifierListCopier.copy(allSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allSecurityGroups(GroupIdentifier ... allSecurityGroups) {
            this.allSecurityGroups(Arrays.asList(allSecurityGroups));
            return this;
        }

        public final void setAllSecurityGroups(Collection<GroupIdentifier> allSecurityGroups) {
            this.allSecurityGroups = GroupIdentifierListCopier.copy(allSecurityGroups);
        }

        public final Boolean getMonitoringEnabled() {
            return this.monitoringEnabled;
        }

        @Override
        public final Builder monitoringEnabled(Boolean monitoringEnabled) {
            this.monitoringEnabled = monitoringEnabled;
            return this;
        }

        public final void setMonitoringEnabled(Boolean monitoringEnabled) {
            this.monitoringEnabled = monitoringEnabled;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = GroupNameStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = GroupNameStringListCopier.copy(securityGroups);
        }

        public LaunchSpecification build() {
            return new LaunchSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LaunchSpecification> {
        public Builder userData(String var1);

        public Builder addressingType(String var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... var1);

        public Builder placement(SpotPlacement var1);

        public Builder ramdiskId(String var1);

        public Builder subnetId(String var1);

        public Builder allSecurityGroups(Collection<GroupIdentifier> var1);

        public Builder allSecurityGroups(GroupIdentifier ... var1);

        public Builder monitoringEnabled(Boolean var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);
    }
}

