/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.InstanceState;
import software.amazon.awssdk.services.ec2.model.InstanceStatusEvent;
import software.amazon.awssdk.services.ec2.model.InstanceStatusEventListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceStatusSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceStatus
implements ToCopyableBuilder<Builder, InstanceStatus> {
    private final String availabilityZone;
    private final List<InstanceStatusEvent> events;
    private final String instanceId;
    private final InstanceState instanceState;
    private final InstanceStatusSummary instanceStatus;
    private final InstanceStatusSummary systemStatus;

    private InstanceStatus(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.events = builder.events;
        this.instanceId = builder.instanceId;
        this.instanceState = builder.instanceState;
        this.instanceStatus = builder.instanceStatus;
        this.systemStatus = builder.systemStatus;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public List<InstanceStatusEvent> events() {
        return this.events;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public InstanceState instanceState() {
        return this.instanceState;
    }

    public InstanceStatusSummary instanceStatus() {
        return this.instanceStatus;
    }

    public InstanceStatusSummary systemStatus() {
        return this.systemStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.instanceState() == null ? 0 : this.instanceState().hashCode());
        hashCode = 31 * hashCode + (this.instanceStatus() == null ? 0 : this.instanceStatus().hashCode());
        hashCode = 31 * hashCode + (this.systemStatus() == null ? 0 : this.systemStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatus)) {
            return false;
        }
        InstanceStatus other = (InstanceStatus)obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceState() == null ^ this.instanceState() == null) {
            return false;
        }
        if (other.instanceState() != null && !other.instanceState().equals(this.instanceState())) {
            return false;
        }
        if (other.instanceStatus() == null ^ this.instanceStatus() == null) {
            return false;
        }
        if (other.instanceStatus() != null && !other.instanceStatus().equals(this.instanceStatus())) {
            return false;
        }
        if (other.systemStatus() == null ^ this.systemStatus() == null) {
            return false;
        }
        return other.systemStatus() == null || other.systemStatus().equals(this.systemStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.instanceState() != null) {
            sb.append("InstanceState: ").append(this.instanceState()).append(",");
        }
        if (this.instanceStatus() != null) {
            sb.append("InstanceStatus: ").append(this.instanceStatus()).append(",");
        }
        if (this.systemStatus() != null) {
            sb.append("SystemStatus: ").append(this.systemStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private List<InstanceStatusEvent> events;
        private String instanceId;
        private InstanceState instanceState;
        private InstanceStatusSummary instanceStatus;
        private InstanceStatusSummary systemStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStatus model) {
            this.setAvailabilityZone(model.availabilityZone);
            this.setEvents(model.events);
            this.setInstanceId(model.instanceId);
            this.setInstanceState(model.instanceState);
            this.setInstanceStatus(model.instanceStatus);
            this.setSystemStatus(model.systemStatus);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<InstanceStatusEvent> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<InstanceStatusEvent> events) {
            this.events = InstanceStatusEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(InstanceStatusEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<InstanceStatusEvent> events) {
            this.events = InstanceStatusEventListCopier.copy(events);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final InstanceState getInstanceState() {
            return this.instanceState;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        public final void setInstanceState(InstanceState instanceState) {
            this.instanceState = instanceState;
        }

        public final InstanceStatusSummary getInstanceStatus() {
            return this.instanceStatus;
        }

        @Override
        public final Builder instanceStatus(InstanceStatusSummary instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public final void setInstanceStatus(InstanceStatusSummary instanceStatus) {
            this.instanceStatus = instanceStatus;
        }

        public final InstanceStatusSummary getSystemStatus() {
            return this.systemStatus;
        }

        @Override
        public final Builder systemStatus(InstanceStatusSummary systemStatus) {
            this.systemStatus = systemStatus;
            return this;
        }

        public final void setSystemStatus(InstanceStatusSummary systemStatus) {
            this.systemStatus = systemStatus;
        }

        public InstanceStatus build() {
            return new InstanceStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceStatus> {
        public Builder availabilityZone(String var1);

        public Builder events(Collection<InstanceStatusEvent> var1);

        public Builder events(InstanceStatusEvent ... var1);

        public Builder instanceId(String var1);

        public Builder instanceState(InstanceState var1);

        public Builder instanceStatus(InstanceStatusSummary var1);

        public Builder systemStatus(InstanceStatusSummary var1);
    }
}

