/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.ScheduledInstance;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScheduledInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeScheduledInstancesResponse> {
    private final String nextToken;
    private final List<ScheduledInstance> scheduledInstanceSet;

    private DescribeScheduledInstancesResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.scheduledInstanceSet = builder.scheduledInstanceSet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ScheduledInstance> scheduledInstanceSet() {
        return this.scheduledInstanceSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.scheduledInstanceSet() == null ? 0 : this.scheduledInstanceSet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstancesResponse)) {
            return false;
        }
        DescribeScheduledInstancesResponse other = (DescribeScheduledInstancesResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.scheduledInstanceSet() == null ^ this.scheduledInstanceSet() == null) {
            return false;
        }
        return other.scheduledInstanceSet() == null || other.scheduledInstanceSet().equals(this.scheduledInstanceSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.scheduledInstanceSet() != null) {
            sb.append("ScheduledInstanceSet: ").append(this.scheduledInstanceSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScheduledInstance> scheduledInstanceSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstancesResponse model) {
            this.setNextToken(model.nextToken);
            this.setScheduledInstanceSet(model.scheduledInstanceSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ScheduledInstance> getScheduledInstanceSet() {
            return this.scheduledInstanceSet;
        }

        @Override
        public final Builder scheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet) {
            this.scheduledInstanceSet = ScheduledInstanceSetCopier.copy(scheduledInstanceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledInstanceSet(ScheduledInstance ... scheduledInstanceSet) {
            this.scheduledInstanceSet(Arrays.asList(scheduledInstanceSet));
            return this;
        }

        public final void setScheduledInstanceSet(Collection<ScheduledInstance> scheduledInstanceSet) {
            this.scheduledInstanceSet = ScheduledInstanceSetCopier.copy(scheduledInstanceSet);
        }

        public DescribeScheduledInstancesResponse build() {
            return new DescribeScheduledInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScheduledInstancesResponse> {
        public Builder nextToken(String var1);

        public Builder scheduledInstanceSet(Collection<ScheduledInstance> var1);

        public Builder scheduledInstanceSet(ScheduledInstance ... var1);
    }
}

