/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesListingsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeReservedInstancesListingsRequest> {
    private final List<Filter> filters;
    private final String reservedInstancesId;
    private final String reservedInstancesListingId;

    private DescribeReservedInstancesListingsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public String reservedInstancesListingId() {
        return this.reservedInstancesListingId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesId() == null ? 0 : this.reservedInstancesId().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesListingId() == null ? 0 : this.reservedInstancesListingId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesListingsRequest)) {
            return false;
        }
        DescribeReservedInstancesListingsRequest other = (DescribeReservedInstancesListingsRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.reservedInstancesId() == null ^ this.reservedInstancesId() == null) {
            return false;
        }
        if (other.reservedInstancesId() != null && !other.reservedInstancesId().equals(this.reservedInstancesId())) {
            return false;
        }
        if (other.reservedInstancesListingId() == null ^ this.reservedInstancesListingId() == null) {
            return false;
        }
        return other.reservedInstancesListingId() == null || other.reservedInstancesListingId().equals(this.reservedInstancesListingId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(this.reservedInstancesId()).append(",");
        }
        if (this.reservedInstancesListingId() != null) {
            sb.append("ReservedInstancesListingId: ").append(this.reservedInstancesListingId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private String reservedInstancesId;
        private String reservedInstancesListingId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesListingsRequest model) {
            this.setFilters(model.filters);
            this.setReservedInstancesId(model.reservedInstancesId);
            this.setReservedInstancesListingId(model.reservedInstancesListingId);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final String getReservedInstancesListingId() {
            return this.reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        public DescribeReservedInstancesListingsRequest build() {
            return new DescribeReservedInstancesListingsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedInstancesListingsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder reservedInstancesId(String var1);

        public Builder reservedInstancesListingId(String var1);
    }
}

