/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeIamInstanceProfileAssociationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeIamInstanceProfileAssociationsResponse> {
    private final List<IamInstanceProfileAssociation> iamInstanceProfileAssociations;
    private final String nextToken;

    private DescribeIamInstanceProfileAssociationsResponse(BuilderImpl builder) {
        this.iamInstanceProfileAssociations = builder.iamInstanceProfileAssociations;
        this.nextToken = builder.nextToken;
    }

    public List<IamInstanceProfileAssociation> iamInstanceProfileAssociations() {
        return this.iamInstanceProfileAssociations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.iamInstanceProfileAssociations() == null ? 0 : this.iamInstanceProfileAssociations().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIamInstanceProfileAssociationsResponse)) {
            return false;
        }
        DescribeIamInstanceProfileAssociationsResponse other = (DescribeIamInstanceProfileAssociationsResponse)((Object)obj);
        if (other.iamInstanceProfileAssociations() == null ^ this.iamInstanceProfileAssociations() == null) {
            return false;
        }
        if (other.iamInstanceProfileAssociations() != null && !other.iamInstanceProfileAssociations().equals(this.iamInstanceProfileAssociations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.iamInstanceProfileAssociations() != null) {
            sb.append("IamInstanceProfileAssociations: ").append(this.iamInstanceProfileAssociations()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<IamInstanceProfileAssociation> iamInstanceProfileAssociations;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIamInstanceProfileAssociationsResponse model) {
            this.setIamInstanceProfileAssociations(model.iamInstanceProfileAssociations);
            this.setNextToken(model.nextToken);
        }

        public final Collection<IamInstanceProfileAssociation> getIamInstanceProfileAssociations() {
            return this.iamInstanceProfileAssociations;
        }

        @Override
        public final Builder iamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier.copy(iamInstanceProfileAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation ... iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations(Arrays.asList(iamInstanceProfileAssociations));
            return this;
        }

        public final void setIamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier.copy(iamInstanceProfileAssociations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeIamInstanceProfileAssociationsResponse build() {
            return new DescribeIamInstanceProfileAssociationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeIamInstanceProfileAssociationsResponse> {
        public Builder iamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation> var1);

        public Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation ... var1);

        public Builder nextToken(String var1);
    }
}

