/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.AccountAttribute;
import software.amazon.awssdk.services.ec2.model.AccountAttributeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAccountAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAccountAttributesResponse> {
    private final List<AccountAttribute> accountAttributes;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        this.accountAttributes = builder.accountAttributes;
    }

    public List<AccountAttribute> accountAttributes() {
        return this.accountAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountAttributes() == null ? 0 : this.accountAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse)((Object)obj);
        if (other.accountAttributes() == null ^ this.accountAttributes() == null) {
            return false;
        }
        return other.accountAttributes() == null || other.accountAttributes().equals(this.accountAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountAttributes() != null) {
            sb.append("AccountAttributes: ").append(this.accountAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AccountAttribute> accountAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            this.setAccountAttributes(model.accountAttributes);
        }

        public final Collection<AccountAttribute> getAccountAttributes() {
            return this.accountAttributes;
        }

        @Override
        public final Builder accountAttributes(Collection<AccountAttribute> accountAttributes) {
            this.accountAttributes = AccountAttributeListCopier.copy(accountAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAttributes(AccountAttribute ... accountAttributes) {
            this.accountAttributes(Arrays.asList(accountAttributes));
            return this;
        }

        public final void setAccountAttributes(Collection<AccountAttribute> accountAttributes) {
            this.accountAttributes = AccountAttributeListCopier.copy(accountAttributes);
        }

        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        public Builder accountAttributes(Collection<AccountAttribute> var1);

        public Builder accountAttributes(AccountAttribute ... var1);
    }
}

