/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.FlowLogsResourceType;
import software.amazon.awssdk.services.ec2.model.TrafficType;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateFlowLogsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateFlowLogsRequest> {
    private final String clientToken;
    private final String deliverLogsPermissionArn;
    private final String logGroupName;
    private final List<String> resourceIds;
    private final String resourceType;
    private final String trafficType;

    private CreateFlowLogsRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.deliverLogsPermissionArn = builder.deliverLogsPermissionArn;
        this.logGroupName = builder.logGroupName;
        this.resourceIds = builder.resourceIds;
        this.resourceType = builder.resourceType;
        this.trafficType = builder.trafficType;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String deliverLogsPermissionArn() {
        return this.deliverLogsPermissionArn;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public List<String> resourceIds() {
        return this.resourceIds;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String trafficType() {
        return this.trafficType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.deliverLogsPermissionArn() == null ? 0 : this.deliverLogsPermissionArn().hashCode());
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.resourceIds() == null ? 0 : this.resourceIds().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.trafficType() == null ? 0 : this.trafficType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowLogsRequest)) {
            return false;
        }
        CreateFlowLogsRequest other = (CreateFlowLogsRequest)((Object)obj);
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.deliverLogsPermissionArn() == null ^ this.deliverLogsPermissionArn() == null) {
            return false;
        }
        if (other.deliverLogsPermissionArn() != null && !other.deliverLogsPermissionArn().equals(this.deliverLogsPermissionArn())) {
            return false;
        }
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.resourceIds() == null ^ this.resourceIds() == null) {
            return false;
        }
        if (other.resourceIds() != null && !other.resourceIds().equals(this.resourceIds())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.trafficType() == null ^ this.trafficType() == null) {
            return false;
        }
        return other.trafficType() == null || other.trafficType().equals(this.trafficType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.deliverLogsPermissionArn() != null) {
            sb.append("DeliverLogsPermissionArn: ").append(this.deliverLogsPermissionArn()).append(",");
        }
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.resourceIds() != null) {
            sb.append("ResourceIds: ").append(this.resourceIds()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.trafficType() != null) {
            sb.append("TrafficType: ").append(this.trafficType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private String deliverLogsPermissionArn;
        private String logGroupName;
        private List<String> resourceIds;
        private String resourceType;
        private String trafficType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowLogsRequest model) {
            this.setClientToken(model.clientToken);
            this.setDeliverLogsPermissionArn(model.deliverLogsPermissionArn);
            this.setLogGroupName(model.logGroupName);
            this.setResourceIds(model.resourceIds);
            this.setResourceType(model.resourceType);
            this.setTrafficType(model.trafficType);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDeliverLogsPermissionArn() {
            return this.deliverLogsPermissionArn;
        }

        @Override
        public final Builder deliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        public final void setDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Collection<String> getResourceIds() {
            return this.resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ValueStringListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ValueStringListCopier.copy(resourceIds);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(FlowLogsResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getTrafficType() {
            return this.trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType.toString());
            return this;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        public CreateFlowLogsRequest build() {
            return new CreateFlowLogsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateFlowLogsRequest> {
        public Builder clientToken(String var1);

        public Builder deliverLogsPermissionArn(String var1);

        public Builder logGroupName(String var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        public Builder resourceType(String var1);

        public Builder resourceType(FlowLogsResourceType var1);

        public Builder trafficType(String var1);

        public Builder trafficType(TrafficType var1);
    }
}

