/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.TargetConfiguration;

public class TargetConfigurationUnmarshaller
implements Unmarshaller<TargetConfiguration, StaxUnmarshallerContext> {
    private static TargetConfigurationUnmarshaller INSTANCE;

    public TargetConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TargetConfiguration.Builder targetConfiguration = TargetConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("instanceCount", targetDepth)) {
                    targetConfiguration.instanceCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("offeringId", targetDepth)) continue;
                targetConfiguration.offeringId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TargetConfiguration)targetConfiguration.build();
    }

    public static TargetConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TargetConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

