/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequest;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.LaunchSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.SpotInstanceStateFaultUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.SpotInstanceStatusUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class SpotInstanceRequestUnmarshaller
implements Unmarshaller<SpotInstanceRequest, StaxUnmarshallerContext> {
    private static SpotInstanceRequestUnmarshaller INSTANCE;

    public SpotInstanceRequest unmarshall(StaxUnmarshallerContext context) throws Exception {
        SpotInstanceRequest.Builder spotInstanceRequest;
        block22: {
            spotInstanceRequest = SpotInstanceRequest.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    spotInstanceRequest.tags(tags);
                    break block22;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("actualBlockHourlyPrice", targetDepth)) {
                        spotInstanceRequest.actualBlockHourlyPrice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("availabilityZoneGroup", targetDepth)) {
                        spotInstanceRequest.availabilityZoneGroup(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("blockDurationMinutes", targetDepth)) {
                        spotInstanceRequest.blockDurationMinutes(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("createTime", targetDepth)) {
                        spotInstanceRequest.createTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("fault", targetDepth)) {
                        spotInstanceRequest.fault(SpotInstanceStateFaultUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceId", targetDepth)) {
                        spotInstanceRequest.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("launchGroup", targetDepth)) {
                        spotInstanceRequest.launchGroup(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("launchSpecification", targetDepth)) {
                        spotInstanceRequest.launchSpecification(LaunchSpecificationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("launchedAvailabilityZone", targetDepth)) {
                        spotInstanceRequest.launchedAvailabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("productDescription", targetDepth)) {
                        spotInstanceRequest.productDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("spotInstanceRequestId", targetDepth)) {
                        spotInstanceRequest.spotInstanceRequestId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("spotPrice", targetDepth)) {
                        spotInstanceRequest.spotPrice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("state", targetDepth)) {
                        spotInstanceRequest.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("status", targetDepth)) {
                        spotInstanceRequest.status(SpotInstanceStatusUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (context.testExpression("tagSet/item", targetDepth)) {
                        tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("type", targetDepth)) {
                        spotInstanceRequest.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("validFrom", targetDepth)) {
                        spotInstanceRequest.validFrom(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("validUntil", targetDepth)) continue;
                    spotInstanceRequest.validUntil(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            spotInstanceRequest.tags(tags);
        }
        return (SpotInstanceRequest)spotInstanceRequest.build();
    }

    public static SpotInstanceRequestUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpotInstanceRequestUnmarshaller();
        }
        return INSTANCE;
    }
}

