/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.PciId;

public class PciIdUnmarshaller
implements Unmarshaller<PciId, StaxUnmarshallerContext> {
    private static PciIdUnmarshaller INSTANCE;

    public PciId unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PciId.Builder pciId = PciId.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DeviceId", targetDepth)) {
                    pciId.deviceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VendorId", targetDepth)) {
                    pciId.vendorId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SubsystemId", targetDepth)) {
                    pciId.subsystemId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SubsystemVendorId", targetDepth)) continue;
                pciId.subsystemVendorId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PciId)pciId.build();
    }

    public static PciIdUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PciIdUnmarshaller();
        }
        return INSTANCE;
    }
}

